<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * JobPlanification.
 */
class JobPlanification  {

  /*
   * @type PlanKind
   */
  public $kind;

  /*
   * @type JobRec
   */
  public $rec;

  /*
   * @type javautilDate
   */
  public $lastRun;

  /*
   * @type javautilDate
   */
  public $nextRun;

  /*
   * @type String
   */
  public $domain;

  /*
   * Constructor
   */
  public function __construct() {
    $this->rec =   new JobRec();
    $this->lastRun = null;
    $this->nextRun = null;
    $this->domain = "";
  }

  public function toMap() {
    $data = array(    
        "kind" => empty($this->kind) ? null : $this->kind,    
        "rec" => empty($this->rec) ? null : $this->rec,    
        "lastRun" => empty($this->lastRun) ? null : $this->lastRun,    
        "nextRun" => empty($this->nextRun) ? null : $this->nextRun,    
        "domain" => empty($this->domain) ? null : $this->domain);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
