<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * JobExecutionQuery.
 */
class JobExecutionQuery  {

  /*
   * @type String
   */
  public $jobId;

  /*
   * @type String
   */
  public $domain;

  /*
   * @type int
   */
  public $id;

  /*
   * @type Set
   */
  public $statuses;

  /*
   * @type boolean
   */
  public $active;

  /*
   * @type int
   */
  public $from;

  /*
   * @type int
   */
  public $size;

  /*
   * Constructor
   */
  public function __construct() {
    $this->jobId = "";
    $this->domain = "";
    $this->id = 0;
    $this->statuses = array();
    $this->active = false;
    $this->from = 0;
    $this->size = 0;
  }

  public function toMap() {
    $data = array(    
        "jobId" => empty($this->jobId) ? null : $this->jobId,    
        "domain" => empty($this->domain) ? null : $this->domain,    
        "id" => empty($this->id) ? null : $this->id,    
        "statuses" => empty($this->statuses) ? null : $this->statuses,    
        "active" => empty($this->active) ? null : $this->active,    
        "from" => empty($this->from) ? null : $this->from,    
        "size" => empty($this->size) ? null : $this->size);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
