package net.bluemind.role.service.validators;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.role.api.BasicRoles;
import net.bluemind.role.api.DefaultRoles;
import net.bluemind.role.provider.IRolesVerifier;

public class SystemManagementRoleRemovalValidator implements IRolesVerifier {

	@Override
	public Set<String> getDeactivatedRoles(Set<String> roles) throws ServerFault {
		List<String> intersectionWithAppRoles = roles.stream().filter(DefaultRoles.DEFAULT_APP_ROLES::contains)
				.distinct().toList();
		return (!intersectionWithAppRoles.isEmpty()
				&& roles.stream().anyMatch(r -> r.equals(BasicRoles.ROLE_SYSTEM_MANAGER)))
						? Set.of(BasicRoles.ROLE_SYSTEM_MANAGER)
						: Collections.<String>emptySet();

	}

}
