/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2017
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.resource.service.event;

import java.time.ZonedDateTime;

import net.bluemind.calendar.api.VFreebusy.Slot;
import net.bluemind.calendar.api.VFreebusy.Type;
import net.bluemind.resource.service.event.BookingStrategyFactory.TentativeEventException;

/**
 * @author mehdi All slot must be free
 */
public class OnlyFreeSlots extends AbstractBookingStrategy implements BookingStrategy {

	protected BookkingDecisionResult check(Slot slot, ZonedDateTime slotStart, ZonedDateTime slotEnd,
			ZonedDateTime evtStart, ZonedDateTime evtEnd) {

		if (slotStart.isBefore(evtEnd) && slotEnd.isAfter(evtStart)) {
			if (slot.type == Type.BUSYTENTATIVE) {
				// skip the event itself
				if (!slotStart.equals(evtStart) || !slotEnd.equals(evtEnd)) {
					throw new TentativeEventException();
				}
			} else if (slot.type != Type.FREE) {
				return new BookkingDecisionResult(Mode.STOP, BookingDecision.BUSY);
			}
		}
		return new BookkingDecisionResult(Mode.CONTINUE, null);
	}

}