<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ResourceDescriptor.
 */
class ResourceDescriptor extends DirBaseValue {

  /*
   * @type String
   */
  public $label;

  /*
   * @type String
   */
  public $typeIdentifier;

  /*
   * @type String
   */
  public $description;

  /*
   * @type ResourceReservationMode
   */
  public $reservationMode;

  /*
   * @type List
   */
  public $properties;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->label = "";
    $this->typeIdentifier = "";
    $this->description = "";
    $this->properties =  array();
  }

  public function toMap() {
    $data = array(    
        "label" => empty($this->label) ? null : $this->label,    
        "typeIdentifier" => empty($this->typeIdentifier) ? null : $this->typeIdentifier,    
        "description" => empty($this->description) ? null : $this->description,    
        "reservationMode" => empty($this->reservationMode) ? null : $this->reservationMode,    
        "properties" => empty($this->properties) ? null : $this->properties);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
