/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.resource.api.type.IResourceTypes.
 */

goog.provide('net.bluemind.resource.api.type.ResourceTypesVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.resource.api.type.IResourceTypes API.
 * @param {string sessionId} sessionId
*  @param {string} domainUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.resource.api.type.ResourceTypesVertxClient = function( sessionId , domainUid ) {
  this.sessionId = sessionId;
  this.base = '/resources/{domainUid}/type';
  this.domainUid_ = domainUid;
  this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.resource.api.type.ResourceTypesVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.resource.api.type.ResourceTypesVertxClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} identifier
 * @param {Object} resourceTypeDescriptor
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesVertxClient.prototype.create = function( identifier ,  resourceTypeDescriptor  ) {

  var postUri = "/{identifier}";

  postUri = postUri.replace("{identifier}", goog.string.urlEncode(identifier));
  var params = {};



  var body = null;
  body = resourceTypeDescriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesVertxClient.prototype.get = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesVertxClient.prototype.getIcon = function( uid  ) {

  var postUri = "/{uid}/icon";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesVertxClient.prototype.getTypes = function() {

  var postUri = "";

  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Array.<number>} icon
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesVertxClient.prototype.setIcon = function( uid ,  icon  ) {

  var postUri = "/{uid}/icon";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = icon;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} resourceTypeDescriptor
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesVertxClient.prototype.update = function( uid ,  resourceTypeDescriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = resourceTypeDescriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

