/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.resource.api.IResources.
 */

goog.provide('net.bluemind.resource.api.ResourcesVertxClient');

goog.require('goog.Uri');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.VertxBlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.resource.api.IResources API.
 * @param {string sessionId} sessionId
*  @param {string} domainUid
 * @extends {net.bluemind.api.VertxBlueMindClient}
 * @constructor
 */
net.bluemind.resource.api.ResourcesVertxClient = function( sessionId , domainUid ) {
  this.sessionId = sessionId;
  this.base = '/resources/{domainUid}';
  this.domainUid_ = domainUid;
  this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.resource.api.ResourcesVertxClient, net.bluemind.api.VertxBlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} eventInfo
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.addToEventDescription = function( uid ,  eventInfo  ) {

  var postUri = "/{uid}/addToEventDesc";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = eventInfo;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.byEmail = function( email  ) {

  var postUri = "/byEmail/{email}";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} type
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.byType = function( type  ) {

  var postUri = "/byType/{type}";

  postUri = postUri.replace("{type}", goog.string.urlEncode(type));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} resourceDescriptor
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.create = function( uid ,  resourceDescriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = resourceDescriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "PUT", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "DELETE", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.get = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.getIcon = function( uid  ) {

  var postUri = "/{uid}/icon";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "GET", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} eventInfo
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.removeFromEventDescription = function( uid ,  eventInfo  ) {

  var postUri = "/{uid}/removeFromEventDesc";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = eventInfo;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Array.<number>} icon
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.setIcon = function( uid ,  icon  ) {

  var postUri = "/{uid}/icon";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = icon;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} resourceDescriptor
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesVertxClient.prototype.update = function( uid ,  resourceDescriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));
  var params = {};



  var body = null;
  body = resourceDescriptor;
  return this.send_( {'X-BM-ApiKey': this.sessionId}, "POST", this.base + postUri, params, body);
};

