/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.resource.api.type.IResourceTypes.
 */

goog.provide('net.bluemind.resource.api.type.ResourceTypesClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.resource.api.type.IResourceTypes API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domainUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.resource.api.type.ResourceTypesClient = function(rpc, base , domainUid ) {
  goog.base(this, rpc, base);
  this.base += '/resources/{domainUid}/type';
   this.domainUid_ = domainUid;
   this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.resource.api.type.ResourceTypesClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.resource.api.type.ResourceTypesClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} identifier
 * @param {Object} resourceTypeDescriptor
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesClient.prototype.create = function( identifier ,  resourceTypeDescriptor  ) {

  var postUri = "/{identifier}";

  postUri = postUri.replace("{identifier}", goog.string.urlEncode(identifier));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + this.domainUid_
                                  + identifier
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = resourceTypeDescriptor;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesClient.prototype.get = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "get_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesClient.prototype.getIcon = function( uid  ) {

  var postUri = "/{uid}/icon";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getIcon_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesClient.prototype.getTypes = function() {

  var postUri = "";


  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getTypes_" 
                                  + this.domainUid_
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Array.<number>} icon
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesClient.prototype.setIcon = function( uid ,  icon  ) {

  var postUri = "/{uid}/icon";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setIcon_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = icon;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} resourceTypeDescriptor
 * @return {Object}
 */
net.bluemind.resource.api.type.ResourceTypesClient.prototype.update = function( uid ,  resourceTypeDescriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = resourceTypeDescriptor;
  return this.execute(cmd, body);
};

