/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview JS implementation of net.bluemind.resource.api.IResources.
 */

goog.provide('net.bluemind.resource.api.ResourcesClient');

goog.require('goog.Uri');
goog.require('relief.rpc.Command');
goog.require('goog.async.Deferred');
goog.require('net.bluemind.api.BlueMindClient');
goog.require('goog.uri.utils');

/**
 * Client implementation for net.bluemind.resource.api.IResources API.
 * @param {relief.rpc.RPCService} rpc RPC Service
 * @param {string} base RPC base path
*  @param {string} domainUid
 * @extends {net.bluemind.api.BlueMindClient}
 * @constructor
 */
net.bluemind.resource.api.ResourcesClient = function(rpc, base , domainUid ) {
  goog.base(this, rpc, base);
  this.base += '/resources/{domainUid}';
   this.domainUid_ = domainUid;
   this.base = this.base.replace('{domainUid}',goog.string.urlEncode(domainUid));
};

goog.inherits(net.bluemind.resource.api.ResourcesClient, net.bluemind.api.BlueMindClient)

/**
 * @type {string} domainUid
 * @private
 */
net.bluemind.resource.api.ResourcesClient.prototype.domainUid_;

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} eventInfo
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.addToEventDescription = function( uid ,  eventInfo  ) {

  var postUri = "/{uid}/addToEventDesc";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "addToEventDescription_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = eventInfo;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} email
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.byEmail = function( email  ) {

  var postUri = "/byEmail/{email}";

  postUri = postUri.replace("{email}", goog.string.urlEncode(email));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "byEmail_" 
                                  + this.domainUid_
                                  + email
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} type
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.byType = function( type  ) {

  var postUri = "/byType/{type}";

  postUri = postUri.replace("{type}", goog.string.urlEncode(type));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "byType_" 
                                  + this.domainUid_
                                  + type
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} resourceDescriptor
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.create = function( uid ,  resourceDescriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "create_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "PUT" );

  var body = null;
  body = resourceDescriptor;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.delete_ = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "delete_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "DELETE" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.get = function( uid  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "get_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.getIcon = function( uid  ) {

  var postUri = "/{uid}/icon";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "getIcon_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "GET" );

  var body = null;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} eventInfo
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.removeFromEventDescription = function( uid ,  eventInfo  ) {

  var postUri = "/{uid}/removeFromEventDesc";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "removeFromEventDescription_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = eventInfo;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Array.<number>} icon
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.setIcon = function( uid ,  icon  ) {

  var postUri = "/{uid}/icon";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "setIcon_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = icon;
  return this.execute(cmd, body);
};

/**
 * // FIXME inject DOC
 * 
 * @param {string} uid
 * @param {Object} resourceDescriptor
 * @return {Object}
 */
net.bluemind.resource.api.ResourcesClient.prototype.update = function( uid ,  resourceDescriptor  ) {

  var postUri = "/{uid}";

  postUri = postUri.replace("{uid}", goog.string.urlEncode(uid));

  var url = new goog.Uri(this.base + postUri);

  var cmd = new relief.rpc.Command(null, null, 
                                  "update_" 
                                  + this.domainUid_
                                  + uid
                                  + goog.string.getRandomString()
                                  , url.toString(), "POST" );

  var body = null;
  body = resourceDescriptor;
  return this.execute(cmd, body);
};

