package net.bluemind.repository.sequences;

import java.util.EnumSet;
import java.util.Set;

public interface ISequenceStore {

	/**
	 * An in-memory impl would provide none of those capabilities
	 * 
	 * A postgresql based impl would be {@link StoreCapability#DURABLE}
	 * 
	 * A keydb cluster would be {@link StoreCapability#DURABLE} but not
	 * {@link StoreCapability#PARTITION_TOLERANT}.
	 * 
	 * Zookeeper would be {@link StoreCapability#DURABLE},
	 * {@link StoreCapability#DISTRIBUTED} and
	 * {@link StoreCapability#PARTITION_TOLERANT}.
	 */
	public enum StoreCapability {
		DURABLE, DISTRIBUTED, PARTITION_TOLERANT
	}

	long curVal(String seq);

	long nextVal(String seq);

	long nextVals(String seq, int count);

	void drop(String itemVersions);

	void setMinimumValue(long minimumValue);

	default Set<StoreCapability> capabilities() {
		return EnumSet.noneOf(StoreCapability.class);
	}

}
