package net.bluemind.repository.sequences;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummySequenceStore implements ISequenceStore {

	private static final Logger logger = LoggerFactory.getLogger(DummySequenceStore.class);

	private static final Map<String, AtomicLong> locks = new ConcurrentHashMap<>();

	@Override
	public long nextVal(String sequenceName) {
		AtomicLong seq = distributedLong(sequenceName);
		return seq.incrementAndGet();
	}

	@Override
	public long nextVals(String sequenceName, int count) {
		AtomicLong seq = distributedLong(sequenceName);
		return seq.addAndGet(count) - count;
	}

	@Override
	public long curVal(String sequenceName) {
		AtomicLong seq = distributedLong(sequenceName);
		return seq.get();
	}

	/**
	 * @param sequenceName eg. {@link Sequences#itemVersions(String)}
	 * @return
	 */
	private AtomicLong distributedLong(String sequenceName) {
		return locks.computeIfAbsent(sequenceName, sn -> {
			logger.warn("Dummy store is only suitable for unit tests, not for {}", sn);
			return new AtomicLong();
		});

	}

	@Override
	public void drop(String seqName) {
		locks.remove(seqName);
	}

	@Override
	public void setMinimumValue(long minimumValue) {
		// NOOP
	}
}
