<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VCardChangesItemAdd.
 */
class VCardChangesItemAdd  {

  /*
   * @type String
   */
  public $uid;

  /*
   * @type VCard
   */
  public $value;

  /*
   * @type []
   */
  public $photo;

  /*
   * Constructor
   */
  public function __construct() {
    $this->uid = "";
    $this->value =   new VCard();
    $this->photo = array();
  }

  public function toMap() {
    $data = array(    
        "uid" => empty($this->uid) ? null : $this->uid,    
        "value" => empty($this->value) ? null : $this->value,    
        "photo" => empty($this->photo) ? null : $this->photo);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
