<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * SearchQuery.
 */
class SearchQuery  {

  /*
   * @type String
   */
  public $searchSessionId;

  /*
   * @type String
   */
  public $query;

  /*
   * @type String
   */
  public $recordQuery;

  /*
   * @type String
   */
  public $messageId;

  /*
   * @type String
   */
  public $references;

  /*
   * @type SearchQueryHeaderQuery
   */
  public $headerQuery;

  /*
   * @type long
   */
  public $maxResults;

  /*
   * @type long
   */
  public $offset;

  /*
   * @type SearchQuerySearchScope
   */
  public $scope;

  /*
   * @type SearchQueryLogicalOperator
   */
  public $logicalOperator;

  /*
   * @type boolean
   */
  public $trackScores;

  /*
   * Constructor
   */
  public function __construct() {
    $this->searchSessionId = "";
    $this->query = "";
    $this->recordQuery = "";
    $this->messageId = "";
    $this->references = "";
    $this->headerQuery =   new SearchQueryHeaderQuery();
    $this->maxResults = 0;
    $this->offset = 0;
    $this->scope =   new SearchQuerySearchScope();
    $this->trackScores = false;
  }

  public function toMap() {
    $data = array(    
        "searchSessionId" => empty($this->searchSessionId) ? null : $this->searchSessionId,    
        "query" => empty($this->query) ? null : $this->query,    
        "recordQuery" => empty($this->recordQuery) ? null : $this->recordQuery,    
        "messageId" => empty($this->messageId) ? null : $this->messageId,    
        "references" => empty($this->references) ? null : $this->references,    
        "headerQuery" => empty($this->headerQuery) ? null : $this->headerQuery,    
        "maxResults" => empty($this->maxResults) ? null : $this->maxResults,    
        "offset" => empty($this->offset) ? null : $this->offset,    
        "scope" => empty($this->scope) ? null : $this->scope,    
        "logicalOperator" => empty($this->logicalOperator) ? null : $this->logicalOperator,    
        "trackScores" => empty($this->trackScores) ? null : $this->trackScores);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
