<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ItemContainerValue.
 */
class ItemContainerValue  {

  /*
   * @type String
   */
  public $containerUid;

  /*
   * @type T
   */
  public $value;

  /*
   * @type String
   */
  public $uid;

  /*
   * @type long
   */
  public $version;

  /*
   * @type String
   */
  public $displayName;

  /*
   * @type String
   */
  public $externalId;

  /*
   * @type String
   */
  public $createdBy;

  /*
   * @type String
   */
  public $updatedBy;

  /*
   * @type javautilDate
   */
  public $created;

  /*
   * @type javautilDate
   */
  public $updated;

  /*
   * Constructor
   */
  public function __construct() {
    $this->containerUid = "";
    $this->value = ;
    $this->uid = "";
    $this->version = 0;
    $this->displayName = "";
    $this->externalId = "";
    $this->createdBy = "";
    $this->updatedBy = "";
    $this->created = null;
    $this->updated = null;
  }

  public function toMap() {
    $data = array(    
        "containerUid" => empty($this->containerUid) ? null : $this->containerUid,    
        "value" => empty($this->value) ? null : $this->value,    
        "uid" => empty($this->uid) ? null : $this->uid,    
        "version" => empty($this->version) ? null : $this->version,    
        "displayName" => empty($this->displayName) ? null : $this->displayName,    
        "externalId" => empty($this->externalId) ? null : $this->externalId,    
        "createdBy" => empty($this->createdBy) ? null : $this->createdBy,    
        "updatedBy" => empty($this->updatedBy) ? null : $this->updatedBy,    
        "created" => empty($this->created) ? null : $this->created,    
        "updated" => empty($this->updated) ? null : $this->updated);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
