<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ICalendarElement.
 */
class ICalendarElement  {

  /*
   * @type BmDateTime
   */
  public $dtstart;

  /*
   * @type String
   */
  public $summary;

  /*
   * @type ICalendarElementClassification
   */
  public $classification;

  /*
   * @type String
   */
  public $location;

  /*
   * @type String
   */
  public $description;

  /*
   * @type Integer
   */
  public $priority;

  /*
   * @type List
   */
  public $alarm;

  /*
   * @type ICalendarElementStatus
   */
  public $status;

  /*
   * @type List
   */
  public $attendees;

  /*
   * @type ICalendarElementOrganizer
   */
  public $organizer;

  /*
   * @type List
   */
  public $categories;

  /*
   * @type Set
   */
  public $exdate;

  /*
   * @type Set
   */
  public $rdate;

  /*
   * @type ICalendarElementRRule
   */
  public $rrule;

  /*
   * @type String
   */
  public $url;

  /*
   * @type String
   */
  public $conference;

  /*
   * @type String
   */
  public $conferenceId;

  /*
   * @type Map
   */
  public $conferenceConfiguration;

  /*
   * @type List
   */
  public $attachments;

  /*
   * @type Map
   */
  public $properties;

  /*
   * @type Integer
   */
  public $sequence;

  /*
   * @type boolean
   */
  public $draft;

  /*
   * Constructor
   */
  public function __construct() {
    $this->dtstart = null;
    $this->summary = "";
    $this->location = "";
    $this->description = "";
    $this->priority = null;
    $this->alarm =  array();
    $this->attendees =  array();
    $this->organizer =   new ICalendarElementOrganizer();
    $this->categories =  array();
    $this->exdate = array();
    $this->rdate = array();
    $this->rrule =   new ICalendarElementRRule();
    $this->url = "";
    $this->conference = "";
    $this->conferenceId = "";
    $this->conferenceConfiguration = array();
    $this->attachments =  array();
    $this->properties = array();
    $this->sequence = null;
    $this->draft = false;
  }

  public function toMap() {
    $data = array(    
        "dtstart" => empty($this->dtstart) ? null : $this->dtstart,    
        "summary" => empty($this->summary) ? null : $this->summary,    
        "classification" => empty($this->classification) ? null : $this->classification,    
        "location" => empty($this->location) ? null : $this->location,    
        "description" => empty($this->description) ? null : $this->description,    
        "priority" => empty($this->priority) ? null : $this->priority,    
        "alarm" => empty($this->alarm) ? null : $this->alarm,    
        "status" => empty($this->status) ? null : $this->status,    
        "attendees" => empty($this->attendees) ? null : $this->attendees,    
        "organizer" => empty($this->organizer) ? null : $this->organizer,    
        "categories" => empty($this->categories) ? null : $this->categories,    
        "exdate" => empty($this->exdate) ? null : $this->exdate,    
        "rdate" => empty($this->rdate) ? null : $this->rdate,    
        "rrule" => empty($this->rrule) ? null : $this->rrule,    
        "url" => empty($this->url) ? null : $this->url,    
        "conference" => empty($this->conference) ? null : $this->conference,    
        "conferenceId" => empty($this->conferenceId) ? null : $this->conferenceId,    
        "conferenceConfiguration" => empty($this->conferenceConfiguration) ? null : $this->conferenceConfiguration,    
        "attachments" => empty($this->attachments) ? null : $this->attachments,    
        "properties" => empty($this->properties) ? null : $this->properties,    
        "sequence" => empty($this->sequence) ? null : $this->sequence,    
        "draft" => empty($this->draft) ? null : $this->draft);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
