<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VFreebusyQuery.
 */
class VFreebusyQuery  {

  /*
   * @type BmDateTime
   */
  public $dtstart;

  /*
   * @type BmDateTime
   */
  public $dtend;

  /*
   * @type List
   */
  public $excludedEvents;

  /*
   * @type boolean
   */
  public $withOOFSlots;

  /*
   * Constructor
   */
  public function __construct() {
    $this->dtstart = null;
    $this->dtend = null;
    $this->excludedEvents =  array();
    $this->withOOFSlots = false;
  }

  public function toMap() {
    $data = array(    
        "dtstart" => empty($this->dtstart) ? null : $this->dtstart,    
        "dtend" => empty($this->dtend) ? null : $this->dtend,    
        "excludedEvents" => empty($this->excludedEvents) ? null : $this->excludedEvents,    
        "withOOFSlots" => empty($this->withOOFSlots) ? null : $this->withOOFSlots);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
