<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ContainerSyncStatus.
 */
class ContainerSyncStatus  {

  /*
   * @type Map
   */
  public $syncTokens;

  /*
   * @type Long
   */
  public $nextSync;

  /*
   * @type javautilDate
   */
  public $lastSync;

  /*
   * @type ContainerSyncStatusStatus
   */
  public $syncStatus;

  /*
   * @type String
   */
  public $syncStatusInfo;

  /*
   * Constructor
   */
  public function __construct() {
    $this->syncTokens = array();
    $this->nextSync = null;
    $this->lastSync = null;
    $this->syncStatusInfo = "";
  }

  public function toMap() {
    $data = array(    
        "syncTokens" => empty($this->syncTokens) ? null : $this->syncTokens,    
        "nextSync" => empty($this->nextSync) ? null : $this->nextSync,    
        "lastSync" => empty($this->lastSync) ? null : $this->lastSync,    
        "syncStatus" => empty($this->syncStatus) ? null : $this->syncStatus,    
        "syncStatusInfo" => empty($this->syncStatusInfo) ? null : $this->syncStatusInfo);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
