<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VFreebusy.
 */
class VFreebusy  {

  /*
   * @type BmDateTime
   */
  public $dtstart;

  /*
   * @type BmDateTime
   */
  public $dtend;

  /*
   * @type List
   */
  public $slots;

  /*
   * Constructor
   */
  public function __construct() {
    $this->dtstart = null;
    $this->dtend = null;
    $this->slots =  array();
  }

  public function toMap() {
    $data = array(    
        "dtstart" => empty($this->dtstart) ? null : $this->dtstart,    
        "dtend" => empty($this->dtend) ? null : $this->dtend,    
        "slots" => empty($this->slots) ? null : $this->slots);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
