<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VCardIdentification.
 */
class VCardIdentification  {

  /*
   * @type VCardIdentificationFormatedName
   */
  public $formatedName;

  /*
   * @type VCardIdentificationName
   */
  public $name;

  /*
   * @type VCardIdentificationNickname
   */
  public $nickname;

  /*
   * @type boolean
   */
  public $photo;

  /*
   * @type []
   */
  public $photoBinary;

  /*
   * @type javautilDate
   */
  public $birthday;

  /*
   * @type javautilDate
   */
  public $anniversary;

  /*
   * @type VCardIdentificationGender
   */
  public $gender;

  /*
   * Constructor
   */
  public function __construct() {
    $this->formatedName =   new VCardIdentificationFormatedName();
    $this->name =   new VCardIdentificationName();
    $this->nickname =   new VCardIdentificationNickname();
    $this->photo = false;
    $this->photoBinary = array();
    $this->birthday = null;
    $this->anniversary = null;
    $this->gender =   new VCardIdentificationGender();
  }

  public function toMap() {
    $data = array(    
        "formatedName" => empty($this->formatedName) ? null : $this->formatedName,    
        "name" => empty($this->name) ? null : $this->name,    
        "nickname" => empty($this->nickname) ? null : $this->nickname,    
        "photo" => empty($this->photo) ? null : $this->photo,    
        "photoBinary" => empty($this->photoBinary) ? null : $this->photoBinary,    
        "birthday" => empty($this->birthday) ? null : $this->birthday,    
        "anniversary" => empty($this->anniversary) ? null : $this->anniversary,    
        "gender" => empty($this->gender) ? null : $this->gender);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
