<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * SimpleShardStats.
 */
class SimpleShardStats  {

  /*
   * @type String
   */
  public $indexName;

  /*
   * @type Set
   */
  public $mailboxes;

  /*
   * @type Set
   */
  public $aliases;

  /*
   * @type long
   */
  public $docCount;

  /*
   * @type long
   */
  public $deletedCount;

  /*
   * @type long
   */
  public $externalRefreshCount;

  /*
   * @type long
   */
  public $externalRefreshDuration;

  /*
   * @type long
   */
  public $size;

  /*
   * Constructor
   */
  public function __construct() {
    $this->indexName = "";
    $this->mailboxes = array();
    $this->aliases = array();
    $this->docCount = 0;
    $this->deletedCount = 0;
    $this->externalRefreshCount = 0;
    $this->externalRefreshDuration = 0;
    $this->size = 0;
  }

  public function toMap() {
    $data = array(    
        "indexName" => empty($this->indexName) ? null : $this->indexName,    
        "mailboxes" => empty($this->mailboxes) ? null : $this->mailboxes,    
        "aliases" => empty($this->aliases) ? null : $this->aliases,    
        "docCount" => empty($this->docCount) ? null : $this->docCount,    
        "deletedCount" => empty($this->deletedCount) ? null : $this->deletedCount,    
        "externalRefreshCount" => empty($this->externalRefreshCount) ? null : $this->externalRefreshCount,    
        "externalRefreshDuration" => empty($this->externalRefreshDuration) ? null : $this->externalRefreshDuration,    
        "size" => empty($this->size) ? null : $this->size);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
