<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MessageBody.
 */
class MessageBody  {

  /*
   * @type String
   */
  public $guid;

  /*
   * @type String
   */
  public $subject;

  /*
   * @type boolean
   */
  public $smartAttach;

  /*
   * @type javautilDate
   */
  public $date;

  /*
   * @type javautilDate
   */
  public $created;

  /*
   * @type int
   */
  public $size;

  /*
   * @type List
   */
  public $headers;

  /*
   * @type List
   */
  public $recipients;

  /*
   * @type String
   */
  public $messageId;

  /*
   * @type List
   */
  public $references;

  /*
   * @type MessageBodyPart
   */
  public $structure;

  /*
   * @type String
   */
  public $preview;

  /*
   * @type int
   */
  public $bodyVersion;

  /*
   * Constructor
   */
  public function __construct() {
    $this->guid = "";
    $this->subject = "";
    $this->smartAttach = false;
    $this->date = null;
    $this->created = null;
    $this->size = 0;
    $this->headers =  array();
    $this->recipients =  array();
    $this->messageId = "";
    $this->references =  array();
    $this->structure =   new MessageBodyPart();
    $this->preview = "";
    $this->bodyVersion = 0;
  }

  public function toMap() {
    $data = array(    
        "guid" => empty($this->guid) ? null : $this->guid,    
        "subject" => empty($this->subject) ? null : $this->subject,    
        "smartAttach" => empty($this->smartAttach) ? null : $this->smartAttach,    
        "date" => empty($this->date) ? null : $this->date,    
        "created" => empty($this->created) ? null : $this->created,    
        "size" => empty($this->size) ? null : $this->size,    
        "headers" => empty($this->headers) ? null : $this->headers,    
        "recipients" => empty($this->recipients) ? null : $this->recipients,    
        "messageId" => empty($this->messageId) ? null : $this->messageId,    
        "references" => empty($this->references) ? null : $this->references,    
        "structure" => empty($this->structure) ? null : $this->structure,    
        "preview" => empty($this->preview) ? null : $this->preview,    
        "bodyVersion" => empty($this->bodyVersion) ? null : $this->bodyVersion);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
