<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MailFilter.
 */
class MailFilter  {

  /*
   * @type List
   */
  public $rules;

  /*
   * @type MailFilterForwarding
   */
  public $forwarding;

  /*
   * @type MailFilterVacation
   */
  public $vacation;

  /*
   * Constructor
   */
  public function __construct() {
    $this->rules =  array();
    $this->forwarding =   new MailFilterForwarding();
    $this->vacation =   new MailFilterVacation();
  }

  public function toMap() {
    $data = array(    
        "rules" => empty($this->rules) ? null : $this->rules,    
        "forwarding" => empty($this->forwarding) ? null : $this->forwarding,    
        "vacation" => empty($this->vacation) ? null : $this->vacation);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
