/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.authentication.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsValidationKind extends JavaScriptObject {

	protected JsValidationKind() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsValidationKind TOKEN()
	/*-{
		return "TOKEN";
	}-*/;

	public static final native JsValidationKind PASSWORD()
	/*-{
		return "PASSWORD";
	}-*/;

	public static final native JsValidationKind PASSWORDEXPIRED()
	/*-{
		return "PASSWORDEXPIRED";
	}-*/;

	public static final native JsValidationKind NONE()
	/*-{
		return "NONE";
	}-*/;

	public static final native JsValidationKind ARCHIVED()
	/*-{
		return "ARCHIVED";
	}-*/;

	public static final JsValidationKind create(net.bluemind.authentication.api.ValidationKind value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case TOKEN:
				return TOKEN();
			case PASSWORD:
				return PASSWORD();
			case PASSWORDEXPIRED:
				return PASSWORDEXPIRED();
			case NONE:
				return NONE();
			case ARCHIVED:
				return ARCHIVED();
			default:
				return null;
			}
		}
	}
}