/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SubscriptionInformationsGwtSerDer implements GwtSerDer<net.bluemind.system.api.SubscriptionInformations> {

	public SubscriptionInformationsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.SubscriptionInformations deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.SubscriptionInformations ret = new net.bluemind.system.api.SubscriptionInformations();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.SubscriptionInformations ret, JSONObject json) {
		JSONValue versionJSON = json.get("version");
		ret.version =  GwtSerDerUtils.STRING.deserialize(versionJSON);
		JSONValue installationVersionJSON = json.get("installationVersion");
		ret.installationVersion =  GwtSerDerUtils.STRING.deserialize(installationVersionJSON);
		JSONValue customerJSON = json.get("customer");
		ret.customer =  GwtSerDerUtils.STRING.deserialize(customerJSON);
		JSONValue customerCodeJSON = json.get("customerCode");
		ret.customerCode =  GwtSerDerUtils.STRING.deserialize(customerCodeJSON);
		JSONValue dealerJSON = json.get("dealer");
		ret.dealer =  GwtSerDerUtils.STRING.deserialize(dealerJSON);
		JSONValue distributorJSON = json.get("distributor");
		ret.distributor =  GwtSerDerUtils.STRING.deserialize(distributorJSON);
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.system.api.gwt.serder.SubscriptionInformationsKindGwtSerDer().deserialize(kindJSON);
		JSONValue startsJSON = json.get("starts");
		ret.starts =  GwtSerDerUtils.DATE.deserialize(startsJSON);
		JSONValue endsJSON = json.get("ends");
		ret.ends =  GwtSerDerUtils.DATE.deserialize(endsJSON);
		JSONValue validJSON = json.get("valid");
		ret.valid =  GwtSerDerUtils.BOOLEAN.deserialize(validJSON);
		JSONValue pubKeyFingerprintJSON = json.get("pubKeyFingerprint");
		ret.pubKeyFingerprint =  GwtSerDerUtils.STRING.deserialize(pubKeyFingerprintJSON);
		JSONValue validProviderJSON = json.get("validProvider");
		ret.validProvider =  GwtSerDerUtils.BOOLEAN.deserialize(validProviderJSON);
		JSONValue fromTechVersionJSON = json.get("fromTechVersion");
		ret.fromTechVersion =  GwtSerDerUtils.STRING.deserialize(fromTechVersionJSON);
		JSONValue indicatorJSON = json.get("indicator");
		ret.indicator =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsInstallationIndicatorGwtSerDer()).deserialize(indicatorJSON);
		JSONValue contactsJSON = json.get("contacts");
		ret.contacts =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(contactsJSON);
		JSONValue messagesJSON = json.get("messages");
		ret.messages =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsMessageGwtSerDer()).deserialize(messagesJSON);
	}

	public void deserializeTo(net.bluemind.system.api.SubscriptionInformations ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("version")) {
			JSONValue versionJSON = json.get("version");
			ret.version =  GwtSerDerUtils.STRING.deserialize(versionJSON);
		}
		if (!childPropertiesToIgnore.contains("installationVersion")) {
			JSONValue installationVersionJSON = json.get("installationVersion");
			ret.installationVersion =  GwtSerDerUtils.STRING.deserialize(installationVersionJSON);
		}
		if (!childPropertiesToIgnore.contains("customer")) {
			JSONValue customerJSON = json.get("customer");
			ret.customer =  GwtSerDerUtils.STRING.deserialize(customerJSON);
		}
		if (!childPropertiesToIgnore.contains("customerCode")) {
			JSONValue customerCodeJSON = json.get("customerCode");
			ret.customerCode =  GwtSerDerUtils.STRING.deserialize(customerCodeJSON);
		}
		if (!childPropertiesToIgnore.contains("dealer")) {
			JSONValue dealerJSON = json.get("dealer");
			ret.dealer =  GwtSerDerUtils.STRING.deserialize(dealerJSON);
		}
		if (!childPropertiesToIgnore.contains("distributor")) {
			JSONValue distributorJSON = json.get("distributor");
			ret.distributor =  GwtSerDerUtils.STRING.deserialize(distributorJSON);
		}
		if (!childPropertiesToIgnore.contains("kind")) {
			JSONValue kindJSON = json.get("kind");
			ret.kind =  new net.bluemind.system.api.gwt.serder.SubscriptionInformationsKindGwtSerDer().deserialize(kindJSON);
		}
		if (!childPropertiesToIgnore.contains("starts")) {
			JSONValue startsJSON = json.get("starts");
			ret.starts =  GwtSerDerUtils.DATE.deserialize(startsJSON);
		}
		if (!childPropertiesToIgnore.contains("ends")) {
			JSONValue endsJSON = json.get("ends");
			ret.ends =  GwtSerDerUtils.DATE.deserialize(endsJSON);
		}
		if (!childPropertiesToIgnore.contains("valid")) {
			JSONValue validJSON = json.get("valid");
			ret.valid =  GwtSerDerUtils.BOOLEAN.deserialize(validJSON);
		}
		if (!childPropertiesToIgnore.contains("pubKeyFingerprint")) {
			JSONValue pubKeyFingerprintJSON = json.get("pubKeyFingerprint");
			ret.pubKeyFingerprint =  GwtSerDerUtils.STRING.deserialize(pubKeyFingerprintJSON);
		}
		if (!childPropertiesToIgnore.contains("validProvider")) {
			JSONValue validProviderJSON = json.get("validProvider");
			ret.validProvider =  GwtSerDerUtils.BOOLEAN.deserialize(validProviderJSON);
		}
		if (!childPropertiesToIgnore.contains("fromTechVersion")) {
			JSONValue fromTechVersionJSON = json.get("fromTechVersion");
			ret.fromTechVersion =  GwtSerDerUtils.STRING.deserialize(fromTechVersionJSON);
		}
		if (!childPropertiesToIgnore.contains("indicator")) {
			JSONValue indicatorJSON = json.get("indicator");
			ret.indicator =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsInstallationIndicatorGwtSerDer()).deserialize(indicatorJSON);
		}
		if (!childPropertiesToIgnore.contains("contacts")) {
			JSONValue contactsJSON = json.get("contacts");
			ret.contacts =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(contactsJSON);
		}
		if (!childPropertiesToIgnore.contains("messages")) {
			JSONValue messagesJSON = json.get("messages");
			ret.messages =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsMessageGwtSerDer()).deserialize(messagesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.SubscriptionInformations o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.SubscriptionInformations o, JSONObject ret) {

		ret.put("version",  GwtSerDerUtils.STRING.serialize( o.version ));
		ret.put("installationVersion",  GwtSerDerUtils.STRING.serialize( o.installationVersion ));
		ret.put("customer",  GwtSerDerUtils.STRING.serialize( o.customer ));
		ret.put("customerCode",  GwtSerDerUtils.STRING.serialize( o.customerCode ));
		ret.put("dealer",  GwtSerDerUtils.STRING.serialize( o.dealer ));
		ret.put("distributor",  GwtSerDerUtils.STRING.serialize( o.distributor ));
		ret.put("kind",  new net.bluemind.system.api.gwt.serder.SubscriptionInformationsKindGwtSerDer().serialize( o.kind ));
		ret.put("starts",  GwtSerDerUtils.DATE.serialize( o.starts ));
		ret.put("ends",  GwtSerDerUtils.DATE.serialize( o.ends ));
		ret.put("valid",  GwtSerDerUtils.BOOLEAN.serialize( o.valid ));
		ret.put("pubKeyFingerprint",  GwtSerDerUtils.STRING.serialize( o.pubKeyFingerprint ));
		ret.put("validProvider",  GwtSerDerUtils.BOOLEAN.serialize( o.validProvider ));
		ret.put("fromTechVersion",  GwtSerDerUtils.STRING.serialize( o.fromTechVersion ));
		ret.put("indicator",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsInstallationIndicatorGwtSerDer()).serialize( o.indicator ));
		ret.put("contacts",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.contacts ));
		ret.put("messages",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsMessageGwtSerDer()).serialize( o.messages ));
	}

	public void serializeTo(net.bluemind.system.api.SubscriptionInformations o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("version")) {
			ret.put("version",  GwtSerDerUtils.STRING.serialize( o.version ));
		}
		if (!childPropertiesToIgnore.contains("installationVersion")) {
			ret.put("installationVersion",  GwtSerDerUtils.STRING.serialize( o.installationVersion ));
		}
		if (!childPropertiesToIgnore.contains("customer")) {
			ret.put("customer",  GwtSerDerUtils.STRING.serialize( o.customer ));
		}
		if (!childPropertiesToIgnore.contains("customerCode")) {
			ret.put("customerCode",  GwtSerDerUtils.STRING.serialize( o.customerCode ));
		}
		if (!childPropertiesToIgnore.contains("dealer")) {
			ret.put("dealer",  GwtSerDerUtils.STRING.serialize( o.dealer ));
		}
		if (!childPropertiesToIgnore.contains("distributor")) {
			ret.put("distributor",  GwtSerDerUtils.STRING.serialize( o.distributor ));
		}
		if (!childPropertiesToIgnore.contains("kind")) {
			ret.put("kind",  new net.bluemind.system.api.gwt.serder.SubscriptionInformationsKindGwtSerDer().serialize( o.kind ));
		}
		if (!childPropertiesToIgnore.contains("starts")) {
			ret.put("starts",  GwtSerDerUtils.DATE.serialize( o.starts ));
		}
		if (!childPropertiesToIgnore.contains("ends")) {
			ret.put("ends",  GwtSerDerUtils.DATE.serialize( o.ends ));
		}
		if (!childPropertiesToIgnore.contains("valid")) {
			ret.put("valid",  GwtSerDerUtils.BOOLEAN.serialize( o.valid ));
		}
		if (!childPropertiesToIgnore.contains("pubKeyFingerprint")) {
			ret.put("pubKeyFingerprint",  GwtSerDerUtils.STRING.serialize( o.pubKeyFingerprint ));
		}
		if (!childPropertiesToIgnore.contains("validProvider")) {
			ret.put("validProvider",  GwtSerDerUtils.BOOLEAN.serialize( o.validProvider ));
		}
		if (!childPropertiesToIgnore.contains("fromTechVersion")) {
			ret.put("fromTechVersion",  GwtSerDerUtils.STRING.serialize( o.fromTechVersion ));
		}
		if (!childPropertiesToIgnore.contains("indicator")) {
			ret.put("indicator",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsInstallationIndicatorGwtSerDer()).serialize( o.indicator ));
		}
		if (!childPropertiesToIgnore.contains("contacts")) {
			ret.put("contacts",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.contacts ));
		}
		if (!childPropertiesToIgnore.contains("messages")) {
			ret.put("messages",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.SubscriptionInformationsMessageGwtSerDer()).serialize( o.messages ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}