/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.conditions.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleFilterEqualsGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals> {

	private net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterGwtSerDer parent = new  net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterGwtSerDer();
	public MailFilterRuleFilterEqualsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals ret = new net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue valuesJSON = json.get("values");
		ret.values =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(valuesJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("values")) {
			JSONValue valuesJSON = json.get("values");
			ret.values =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(valuesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("values",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.values ));
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterEquals o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("values")) {
			ret.put("values",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.values ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}