/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailboxQuotaGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.MailboxQuota> {

	public MailboxQuotaGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.MailboxQuota deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.MailboxQuota ret = new net.bluemind.mailbox.api.MailboxQuota();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailboxQuota ret, JSONObject json) {
		JSONValue usedJSON = json.get("used");
		ret.used =  GwtSerDerUtils.INT.deserialize(usedJSON);
		JSONValue quotaJSON = json.get("quota");
		ret.quota =  GwtSerDerUtils.INT.deserialize(quotaJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailboxQuota ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("used")) {
			JSONValue usedJSON = json.get("used");
			ret.used =  GwtSerDerUtils.INT.deserialize(usedJSON);
		}
		if (!childPropertiesToIgnore.contains("quota")) {
			JSONValue quotaJSON = json.get("quota");
			ret.quota =  GwtSerDerUtils.INT.deserialize(quotaJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.MailboxQuota o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.MailboxQuota o, JSONObject ret) {

		ret.put("used",  GwtSerDerUtils.INT.serialize( o.used ));
		ret.put("quota",  GwtSerDerUtils.INT.serialize( o.quota ));
	}

	public void serializeTo(net.bluemind.mailbox.api.MailboxQuota o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("used")) {
			ret.put("used",  GwtSerDerUtils.INT.serialize( o.used ));
		}
		if (!childPropertiesToIgnore.contains("quota")) {
			ret.put("quota",  GwtSerDerUtils.INT.serialize( o.quota ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}