/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.addressbook.api;

import java.util.Set;

import net.bluemind.core.api.BMApi;

@BMApi(version = "3")
public class CertInfo {

	@BMApi(version = "3")
	public enum CertUsage {
		digitalSignature(0), nonRepudiation(1), keyEncipherment(2), dataEncipherment(3), keyAgreement(4),
		keyCertSign(5), cRLSign(6), encipherOnly(7), decipherOnly(8);

		private int pos;

		private CertUsage(int pos) {
			this.pos = pos;
		}

		public int pos() {
			return pos;
		}
	}

	public Set<CertUsage> usage;

	public byte[] x509Certificate;

}
