/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.rules.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsRuleMoveDirection extends JavaScriptObject {

	protected JsRuleMoveDirection() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsRuleMoveDirection UP()
	/*-{
		return "UP";
	}-*/;

	public static final native JsRuleMoveDirection DOWN()
	/*-{
		return "DOWN";
	}-*/;

	public static final native JsRuleMoveDirection TOP()
	/*-{
		return "TOP";
	}-*/;

	public static final native JsRuleMoveDirection BOTTOM()
	/*-{
		return "BOTTOM";
	}-*/;

	public static final JsRuleMoveDirection create(net.bluemind.mailbox.api.rules.RuleMoveDirection value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case UP:
				return UP();
			case DOWN:
				return DOWN();
			case TOP:
				return TOP();
			case BOTTOM:
				return BOTTOM();
			default:
				return null;
			}
		}
	}
}