/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailboxRouting extends JavaScriptObject {

	protected JsMailboxRouting() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsMailboxRouting internal()
	/*-{
		return "internal";
	}-*/;

	public static final native JsMailboxRouting external()
	/*-{
		return "external";
	}-*/;

	public static final native JsMailboxRouting none()
	/*-{
		return "none";
	}-*/;

	public static final JsMailboxRouting create(net.bluemind.mailbox.api.Mailbox.Routing value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case internal:
				return internal();
			case external:
				return external();
			case none:
				return none();
			default:
				return null;
			}
		}
	}
}