/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class AuthUserGwtSerDer implements GwtSerDer<net.bluemind.authentication.api.AuthUser> {

	public AuthUserGwtSerDer( ) {
	}

	@Override
	public net.bluemind.authentication.api.AuthUser deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.authentication.api.AuthUser ret = new net.bluemind.authentication.api.AuthUser();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.authentication.api.AuthUser ret, JSONObject json) {
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue domainUidJSON = json.get("domainUid");
		ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  new net.bluemind.user.api.gwt.serder.UserGwtSerDer().deserialize(valueJSON);
		JSONValue rolesJSON = json.get("roles");
		ret.roles =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(rolesJSON);
		JSONValue rolesByOUJSON = json.get("rolesByOU");
		ret.rolesByOU =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING)).deserialize(rolesByOUJSON);
		JSONValue settingsJSON = json.get("settings");
		ret.settings =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(settingsJSON);
	}

	public void deserializeTo(net.bluemind.authentication.api.AuthUser ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("uid")) {
			JSONValue uidJSON = json.get("uid");
			ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		}
		if (!childPropertiesToIgnore.contains("domainUid")) {
			JSONValue domainUidJSON = json.get("domainUid");
			ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		}
		if (!childPropertiesToIgnore.contains("displayName")) {
			JSONValue displayNameJSON = json.get("displayName");
			ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		}
		if (!childPropertiesToIgnore.contains("value")) {
			JSONValue valueJSON = json.get("value");
			ret.value =  new net.bluemind.user.api.gwt.serder.UserGwtSerDer().deserialize(valueJSON);
		}
		if (!childPropertiesToIgnore.contains("roles")) {
			JSONValue rolesJSON = json.get("roles");
			ret.roles =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(rolesJSON);
		}
		if (!childPropertiesToIgnore.contains("rolesByOU")) {
			JSONValue rolesByOUJSON = json.get("rolesByOU");
			ret.rolesByOU =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING)).deserialize(rolesByOUJSON);
		}
		if (!childPropertiesToIgnore.contains("settings")) {
			JSONValue settingsJSON = json.get("settings");
			ret.settings =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(settingsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.authentication.api.AuthUser o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.authentication.api.AuthUser o, JSONObject ret) {

		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		ret.put("value",  new net.bluemind.user.api.gwt.serder.UserGwtSerDer().serialize( o.value ));
		ret.put("roles",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.roles ));
		ret.put("rolesByOU",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING)).serialize( o.rolesByOU ));
		ret.put("settings",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.settings ));
	}

	public void serializeTo(net.bluemind.authentication.api.AuthUser o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("uid")) {
			ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		}
		if (!childPropertiesToIgnore.contains("domainUid")) {
			ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		}
		if (!childPropertiesToIgnore.contains("displayName")) {
			ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		}
		if (!childPropertiesToIgnore.contains("value")) {
			ret.put("value",  new net.bluemind.user.api.gwt.serder.UserGwtSerDer().serialize( o.value ));
		}
		if (!childPropertiesToIgnore.contains("roles")) {
			ret.put("roles",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.roles ));
		}
		if (!childPropertiesToIgnore.contains("rolesByOU")) {
			ret.put("rolesByOU",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING)).serialize( o.rolesByOU ));
		}
		if (!childPropertiesToIgnore.contains("settings")) {
			ret.put("settings",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.settings ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}