/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.core.api.date.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsBmDateTimePrecision extends JavaScriptObject {

	protected JsBmDateTimePrecision() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsBmDateTimePrecision Date()
	/*-{
		return "Date";
	}-*/;

	public static final native JsBmDateTimePrecision DateTime()
	/*-{
		return "DateTime";
	}-*/;

	public static final JsBmDateTimePrecision create(net.bluemind.core.api.date.BmDateTime.Precision value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Date:
				return Date();
			case DateTime:
				return DateTime();
			default:
				return null;
			}
		}
	}
}