/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.hot.upgrade.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class HotUpgradeStepEventGwtSerDer implements GwtSerDer<net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent> {

	public HotUpgradeStepEventGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent ret = new net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent ret, JSONObject json) {
		JSONValue stepJSON = json.get("step");
		ret.step =  GwtSerDerUtils.STRING.deserialize(stepJSON);
		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeStepEventStatusGwtSerDer().deserialize(statusJSON);
		JSONValue messageJSON = json.get("message");
		ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		JSONValue dateJSON = json.get("date");
		ret.date =  GwtSerDerUtils.LONG.deserialize(dateJSON);
	}

	public void deserializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("step")) {
			JSONValue stepJSON = json.get("step");
			ret.step =  GwtSerDerUtils.STRING.deserialize(stepJSON);
		}
		if (!childPropertiesToIgnore.contains("status")) {
			JSONValue statusJSON = json.get("status");
			ret.status =  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeStepEventStatusGwtSerDer().deserialize(statusJSON);
		}
		if (!childPropertiesToIgnore.contains("message")) {
			JSONValue messageJSON = json.get("message");
			ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		}
		if (!childPropertiesToIgnore.contains("date")) {
			JSONValue dateJSON = json.get("date");
			ret.date =  GwtSerDerUtils.LONG.deserialize(dateJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent o, JSONObject ret) {

		ret.put("step",  GwtSerDerUtils.STRING.serialize( o.step ));
		ret.put("status",  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeStepEventStatusGwtSerDer().serialize( o.status ));
		ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		ret.put("date",  GwtSerDerUtils.LONG.serialize( o.date ));
	}

	public void serializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeStepEvent o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("step")) {
			ret.put("step",  GwtSerDerUtils.STRING.serialize( o.step ));
		}
		if (!childPropertiesToIgnore.contains("status")) {
			ret.put("status",  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeStepEventStatusGwtSerDer().serialize( o.status ));
		}
		if (!childPropertiesToIgnore.contains("message")) {
			ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		}
		if (!childPropertiesToIgnore.contains("date")) {
			ret.put("date",  GwtSerDerUtils.LONG.serialize( o.date ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}