/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class UpgradeStatusGwtSerDer implements GwtSerDer<net.bluemind.system.api.UpgradeStatus> {

	public UpgradeStatusGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.UpgradeStatus deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.UpgradeStatus ret = new net.bluemind.system.api.UpgradeStatus();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.UpgradeStatus ret, JSONObject json) {
		JSONValue messageJSON = json.get("message");
		ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		JSONValue stateJSON = json.get("state");
		ret.state =  new net.bluemind.system.api.gwt.serder.UpgradeStatusStateGwtSerDer().deserialize(stateJSON);
	}

	public void deserializeTo(net.bluemind.system.api.UpgradeStatus ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("message")) {
			JSONValue messageJSON = json.get("message");
			ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		}
		if (!childPropertiesToIgnore.contains("state")) {
			JSONValue stateJSON = json.get("state");
			ret.state =  new net.bluemind.system.api.gwt.serder.UpgradeStatusStateGwtSerDer().deserialize(stateJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.UpgradeStatus o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.UpgradeStatus o, JSONObject ret) {

		ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		ret.put("state",  new net.bluemind.system.api.gwt.serder.UpgradeStatusStateGwtSerDer().serialize( o.state ));
	}

	public void serializeTo(net.bluemind.system.api.UpgradeStatus o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("message")) {
			ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		}
		if (!childPropertiesToIgnore.contains("state")) {
			ret.put("state",  new net.bluemind.system.api.gwt.serder.UpgradeStatusStateGwtSerDer().serialize( o.state ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}