/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardDeliveryAddressingAddressGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.DeliveryAddressing.Address> {

	private net.bluemind.addressbook.api.gwt.serder.VCardBasicAttributeGwtSerDer parent = new  net.bluemind.addressbook.api.gwt.serder.VCardBasicAttributeGwtSerDer();
	public VCardDeliveryAddressingAddressGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.DeliveryAddressing.Address deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.DeliveryAddressing.Address ret = new net.bluemind.addressbook.api.VCard.DeliveryAddressing.Address();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.DeliveryAddressing.Address ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue postOfficeBoxJSON = json.get("postOfficeBox");
		ret.postOfficeBox =  GwtSerDerUtils.STRING.deserialize(postOfficeBoxJSON);
		JSONValue extentedAddressJSON = json.get("extentedAddress");
		ret.extentedAddress =  GwtSerDerUtils.STRING.deserialize(extentedAddressJSON);
		JSONValue streetAddressJSON = json.get("streetAddress");
		ret.streetAddress =  GwtSerDerUtils.STRING.deserialize(streetAddressJSON);
		JSONValue localityJSON = json.get("locality");
		ret.locality =  GwtSerDerUtils.STRING.deserialize(localityJSON);
		JSONValue regionJSON = json.get("region");
		ret.region =  GwtSerDerUtils.STRING.deserialize(regionJSON);
		JSONValue postalCodeJSON = json.get("postalCode");
		ret.postalCode =  GwtSerDerUtils.STRING.deserialize(postalCodeJSON);
		JSONValue countryNameJSON = json.get("countryName");
		ret.countryName =  GwtSerDerUtils.STRING.deserialize(countryNameJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.DeliveryAddressing.Address ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("postOfficeBox")) {
			JSONValue postOfficeBoxJSON = json.get("postOfficeBox");
			ret.postOfficeBox =  GwtSerDerUtils.STRING.deserialize(postOfficeBoxJSON);
		}
		if (!childPropertiesToIgnore.contains("extentedAddress")) {
			JSONValue extentedAddressJSON = json.get("extentedAddress");
			ret.extentedAddress =  GwtSerDerUtils.STRING.deserialize(extentedAddressJSON);
		}
		if (!childPropertiesToIgnore.contains("streetAddress")) {
			JSONValue streetAddressJSON = json.get("streetAddress");
			ret.streetAddress =  GwtSerDerUtils.STRING.deserialize(streetAddressJSON);
		}
		if (!childPropertiesToIgnore.contains("locality")) {
			JSONValue localityJSON = json.get("locality");
			ret.locality =  GwtSerDerUtils.STRING.deserialize(localityJSON);
		}
		if (!childPropertiesToIgnore.contains("region")) {
			JSONValue regionJSON = json.get("region");
			ret.region =  GwtSerDerUtils.STRING.deserialize(regionJSON);
		}
		if (!childPropertiesToIgnore.contains("postalCode")) {
			JSONValue postalCodeJSON = json.get("postalCode");
			ret.postalCode =  GwtSerDerUtils.STRING.deserialize(postalCodeJSON);
		}
		if (!childPropertiesToIgnore.contains("countryName")) {
			JSONValue countryNameJSON = json.get("countryName");
			ret.countryName =  GwtSerDerUtils.STRING.deserialize(countryNameJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.DeliveryAddressing.Address o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.DeliveryAddressing.Address o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("postOfficeBox",  GwtSerDerUtils.STRING.serialize( o.postOfficeBox ));
		ret.put("extentedAddress",  GwtSerDerUtils.STRING.serialize( o.extentedAddress ));
		ret.put("streetAddress",  GwtSerDerUtils.STRING.serialize( o.streetAddress ));
		ret.put("locality",  GwtSerDerUtils.STRING.serialize( o.locality ));
		ret.put("region",  GwtSerDerUtils.STRING.serialize( o.region ));
		ret.put("postalCode",  GwtSerDerUtils.STRING.serialize( o.postalCode ));
		ret.put("countryName",  GwtSerDerUtils.STRING.serialize( o.countryName ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.DeliveryAddressing.Address o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("postOfficeBox")) {
			ret.put("postOfficeBox",  GwtSerDerUtils.STRING.serialize( o.postOfficeBox ));
		}
		if (!childPropertiesToIgnore.contains("extentedAddress")) {
			ret.put("extentedAddress",  GwtSerDerUtils.STRING.serialize( o.extentedAddress ));
		}
		if (!childPropertiesToIgnore.contains("streetAddress")) {
			ret.put("streetAddress",  GwtSerDerUtils.STRING.serialize( o.streetAddress ));
		}
		if (!childPropertiesToIgnore.contains("locality")) {
			ret.put("locality",  GwtSerDerUtils.STRING.serialize( o.locality ));
		}
		if (!childPropertiesToIgnore.contains("region")) {
			ret.put("region",  GwtSerDerUtils.STRING.serialize( o.region ));
		}
		if (!childPropertiesToIgnore.contains("postalCode")) {
			ret.put("postalCode",  GwtSerDerUtils.STRING.serialize( o.postalCode ));
		}
		if (!childPropertiesToIgnore.contains("countryName")) {
			ret.put("countryName",  GwtSerDerUtils.STRING.serialize( o.countryName ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}