/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.hot.upgrade.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class HotUpgradeProgressGwtSerDer implements GwtSerDer<net.bluemind.system.api.hot.upgrade.HotUpgradeProgress> {

	public HotUpgradeProgressGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.hot.upgrade.HotUpgradeProgress deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.hot.upgrade.HotUpgradeProgress ret = new net.bluemind.system.api.hot.upgrade.HotUpgradeProgress();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeProgress ret, JSONObject json) {
		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer().deserialize(statusJSON);
		JSONValue countJSON = json.get("count");
		ret.count =  GwtSerDerUtils.LONG.deserialize(countJSON);
		JSONValue lastUpdatedAtJSON = json.get("lastUpdatedAt");
		ret.lastUpdatedAt =  GwtSerDerUtils.DATE.deserialize(lastUpdatedAtJSON);
	}

	public void deserializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeProgress ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("status")) {
			JSONValue statusJSON = json.get("status");
			ret.status =  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer().deserialize(statusJSON);
		}
		if (!childPropertiesToIgnore.contains("count")) {
			JSONValue countJSON = json.get("count");
			ret.count =  GwtSerDerUtils.LONG.deserialize(countJSON);
		}
		if (!childPropertiesToIgnore.contains("lastUpdatedAt")) {
			JSONValue lastUpdatedAtJSON = json.get("lastUpdatedAt");
			ret.lastUpdatedAt =  GwtSerDerUtils.DATE.deserialize(lastUpdatedAtJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.hot.upgrade.HotUpgradeProgress o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeProgress o, JSONObject ret) {

		ret.put("status",  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer().serialize( o.status ));
		ret.put("count",  GwtSerDerUtils.LONG.serialize( o.count ));
		ret.put("lastUpdatedAt",  GwtSerDerUtils.DATE.serialize( o.lastUpdatedAt ));
	}

	public void serializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeProgress o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("status")) {
			ret.put("status",  new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer().serialize( o.status ));
		}
		if (!childPropertiesToIgnore.contains("count")) {
			ret.put("count",  GwtSerDerUtils.LONG.serialize( o.count ));
		}
		if (!childPropertiesToIgnore.contains("lastUpdatedAt")) {
			ret.put("lastUpdatedAt",  GwtSerDerUtils.DATE.serialize( o.lastUpdatedAt ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}