/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SchemaCheckInfoGwtSerDer implements GwtSerDer<net.bluemind.system.api.SchemaCheckInfo> {

	public SchemaCheckInfoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.SchemaCheckInfo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.SchemaCheckInfo ret = new net.bluemind.system.api.SchemaCheckInfo();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.SchemaCheckInfo ret, JSONObject json) {
		JSONValue serverJSON = json.get("server");
		ret.server =  GwtSerDerUtils.STRING.deserialize(serverJSON);
		JSONValue dbJSON = json.get("db");
		ret.db =  GwtSerDerUtils.STRING.deserialize(dbJSON);
		JSONValue statementsJSON = json.get("statements");
		ret.statements =  GwtSerDerUtils.STRING.deserialize(statementsJSON);
	}

	public void deserializeTo(net.bluemind.system.api.SchemaCheckInfo ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("server")) {
			JSONValue serverJSON = json.get("server");
			ret.server =  GwtSerDerUtils.STRING.deserialize(serverJSON);
		}
		if (!childPropertiesToIgnore.contains("db")) {
			JSONValue dbJSON = json.get("db");
			ret.db =  GwtSerDerUtils.STRING.deserialize(dbJSON);
		}
		if (!childPropertiesToIgnore.contains("statements")) {
			JSONValue statementsJSON = json.get("statements");
			ret.statements =  GwtSerDerUtils.STRING.deserialize(statementsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.SchemaCheckInfo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.SchemaCheckInfo o, JSONObject ret) {

		ret.put("server",  GwtSerDerUtils.STRING.serialize( o.server ));
		ret.put("db",  GwtSerDerUtils.STRING.serialize( o.db ));
		ret.put("statements",  GwtSerDerUtils.STRING.serialize( o.statements ));
	}

	public void serializeTo(net.bluemind.system.api.SchemaCheckInfo o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("server")) {
			ret.put("server",  GwtSerDerUtils.STRING.serialize( o.server ));
		}
		if (!childPropertiesToIgnore.contains("db")) {
			ret.put("db",  GwtSerDerUtils.STRING.serialize( o.db ));
		}
		if (!childPropertiesToIgnore.contains("statements")) {
			ret.put("statements",  GwtSerDerUtils.STRING.serialize( o.statements ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}