/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CredentialGwtSerDer implements GwtSerDer<net.bluemind.system.api.Credential> {

	public CredentialGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.Credential deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.Credential ret = new net.bluemind.system.api.Credential();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.Credential ret, JSONObject json) {
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  GwtSerDerUtils.STRING.deserialize(typeJSON);
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue createdJSON = json.get("created");
		ret.created =  GwtSerDerUtils.LONG.deserialize(createdJSON);
		JSONValue secretJSON = json.get("secret");
		ret.secret =  GwtSerDerUtils.STRING.deserialize(secretJSON);
		JSONValue credentialJSON = json.get("credential");
		ret.credential =  GwtSerDerUtils.STRING.deserialize(credentialJSON);
	}

	public void deserializeTo(net.bluemind.system.api.Credential ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("id")) {
			JSONValue idJSON = json.get("id");
			ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  GwtSerDerUtils.STRING.deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("label")) {
			JSONValue labelJSON = json.get("label");
			ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		}
		if (!childPropertiesToIgnore.contains("created")) {
			JSONValue createdJSON = json.get("created");
			ret.created =  GwtSerDerUtils.LONG.deserialize(createdJSON);
		}
		if (!childPropertiesToIgnore.contains("secret")) {
			JSONValue secretJSON = json.get("secret");
			ret.secret =  GwtSerDerUtils.STRING.deserialize(secretJSON);
		}
		if (!childPropertiesToIgnore.contains("credential")) {
			JSONValue credentialJSON = json.get("credential");
			ret.credential =  GwtSerDerUtils.STRING.deserialize(credentialJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.Credential o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.Credential o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		ret.put("type",  GwtSerDerUtils.STRING.serialize( o.type ));
		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("created",  GwtSerDerUtils.LONG.serialize( o.created ));
		ret.put("secret",  GwtSerDerUtils.STRING.serialize( o.secret ));
		ret.put("credential",  GwtSerDerUtils.STRING.serialize( o.credential ));
	}

	public void serializeTo(net.bluemind.system.api.Credential o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("id")) {
			ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  GwtSerDerUtils.STRING.serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("label")) {
			ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		}
		if (!childPropertiesToIgnore.contains("created")) {
			ret.put("created",  GwtSerDerUtils.LONG.serialize( o.created ));
		}
		if (!childPropertiesToIgnore.contains("secret")) {
			ret.put("secret",  GwtSerDerUtils.STRING.serialize( o.secret ));
		}
		if (!childPropertiesToIgnore.contains("credential")) {
			ret.put("credential",  GwtSerDerUtils.STRING.serialize( o.credential ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}