/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsSubscriptionInformationsMessageCode extends JavaScriptObject {

	protected JsSubscriptionInformationsMessageCode() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsSubscriptionInformationsMessageCode Unknown()
	/*-{
		return "Unknown";
	}-*/;

	public static final native JsSubscriptionInformationsMessageCode InvalidSignature()
	/*-{
		return "InvalidSignature";
	}-*/;

	public static final native JsSubscriptionInformationsMessageCode MaxAccounts()
	/*-{
		return "MaxAccounts";
	}-*/;

	public static final native JsSubscriptionInformationsMessageCode Expired()
	/*-{
		return "Expired";
	}-*/;

	public static final JsSubscriptionInformationsMessageCode create(net.bluemind.system.api.SubscriptionInformations.Message.Code value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Unknown:
				return Unknown();
			case InvalidSignature:
				return InvalidSignature();
			case MaxAccounts:
				return MaxAccounts();
			case Expired:
				return Expired();
			default:
				return null;
			}
		}
	}
}