/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class InternalCredentialsGwtEndpoint implements net.bluemind.system.api.IInternalCredentialsAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public InternalCredentialsGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/credentials/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public InternalCredentialsGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void addUserCredential(String userUid, net.bluemind.system.api.Credential credential, final AsyncHandler<Void> handler) {
		String postUri = "/user/{userUid}";

		postUri = postUri.replace("{userUid}", URL.encodePathSegment(""+userUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.system.api.gwt.serder.CredentialGwtSerDer().serialize( credential);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void addUserCredentials(String userUid, List<net.bluemind.system.api.Credential> credentials, final AsyncHandler<Void> handler) {
		String postUri = "/user/{userUid}/_credentials";

		postUri = postUri.replace("{userUid}", URL.encodePathSegment(""+userUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.CredentialGwtSerDer()).serialize( credentials);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getDomainCredentialById(String credentialId, final AsyncHandler<String> handler) {
		String postUri = "/{credentialId}";

		postUri = postUri.replace("{credentialId}", URL.encodePathSegment(""+credentialId));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<String>(handler) {
			@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getObfuscatedUserCredentials(String userUid, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>> handler) {
		String postUri = "/user/{userUid}";

		postUri = postUri.replace("{userUid}", URL.encodePathSegment(""+userUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>>(handler) {
			@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.system.api.gwt.serder.CredentialGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getUserCredentials(String userUid, final AsyncHandler<List<net.bluemind.system.api.Credential>> handler) {
		String postUri = "/user/{userUid}/plain";

		postUri = postUri.replace("{userUid}", URL.encodePathSegment(""+userUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.system.api.Credential>>(handler) {
			@Override
			protected List<net.bluemind.system.api.Credential> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.CredentialGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void removeUserCredential(String userUid, String credentialId, final AsyncHandler<Void> handler) {
		String postUri = "/user/{userUid}/{credentialId}";

		postUri = postUri.replace("{userUid}", URL.encodePathSegment(""+userUid));
		postUri = postUri.replace("{credentialId}", URL.encodePathSegment(""+credentialId));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.system.api.IInternalCredentialsPromise promiseApi() {
		return new InternalCredentialsEndpointPromise(this);
	}
}
