/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import net.bluemind.core.api.BMApi;
import net.bluemind.core.api.ListResult;

@BMApi(version = "3")
@Path("/credentials/{domainUid}")
public interface ICredentials {
	/**
	 * Value to use when sending credential to external clients
	 */
	public static final String OBFUSCATED_CREDENTIAL_VALUE = "****";

	/**
	 * Remove user credential from its ID<br/>
	 * 
	 * Used by bm-keycloak to store credentials
	 * 
	 * @param userUid
	 * @param credentialId
	 */
	@DELETE
	@Path("user/{userUid}/{credentialId}")
	public void removeUserCredential(@PathParam(value = "userUid") String userUid,
			@PathParam(value = "credentialId") String credentialId);

	@GET
	@Path("user/{userUid}")
	public ListResult<Credential> getObfuscatedUserCredentials(@PathParam(value = "userUid") String userUid);
}
