/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DirBaseValueGwtSerDer implements GwtSerDer<net.bluemind.directory.api.DirBaseValue> {

	public DirBaseValueGwtSerDer( ) {
	}

	@Override
	public net.bluemind.directory.api.DirBaseValue deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.directory.api.DirBaseValue ret = new net.bluemind.directory.api.DirBaseValue();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.directory.api.DirBaseValue ret, JSONObject json) {
		JSONValue orgUnitUidJSON = json.get("orgUnitUid");
		ret.orgUnitUid =  GwtSerDerUtils.STRING.deserialize(orgUnitUidJSON);
		JSONValue emailsJSON = json.get("emails");
		ret.emails =  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).deserialize(emailsJSON);
		JSONValue hiddenJSON = json.get("hidden");
		ret.hidden =  GwtSerDerUtils.BOOLEAN.deserialize(hiddenJSON);
		JSONValue archivedJSON = json.get("archived");
		ret.archived =  GwtSerDerUtils.BOOLEAN.deserialize(archivedJSON);
		JSONValue systemJSON = json.get("system");
		ret.system =  GwtSerDerUtils.BOOLEAN.deserialize(systemJSON);
		JSONValue dataLocationJSON = json.get("dataLocation");
		ret.dataLocation =  GwtSerDerUtils.STRING.deserialize(dataLocationJSON);
	}

	public void deserializeTo(net.bluemind.directory.api.DirBaseValue ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("orgUnitUid")) {
			JSONValue orgUnitUidJSON = json.get("orgUnitUid");
			ret.orgUnitUid =  GwtSerDerUtils.STRING.deserialize(orgUnitUidJSON);
		}
		if (!childPropertiesToIgnore.contains("emails")) {
			JSONValue emailsJSON = json.get("emails");
			ret.emails =  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).deserialize(emailsJSON);
		}
		if (!childPropertiesToIgnore.contains("hidden")) {
			JSONValue hiddenJSON = json.get("hidden");
			ret.hidden =  GwtSerDerUtils.BOOLEAN.deserialize(hiddenJSON);
		}
		if (!childPropertiesToIgnore.contains("archived")) {
			JSONValue archivedJSON = json.get("archived");
			ret.archived =  GwtSerDerUtils.BOOLEAN.deserialize(archivedJSON);
		}
		if (!childPropertiesToIgnore.contains("system")) {
			JSONValue systemJSON = json.get("system");
			ret.system =  GwtSerDerUtils.BOOLEAN.deserialize(systemJSON);
		}
		if (!childPropertiesToIgnore.contains("dataLocation")) {
			JSONValue dataLocationJSON = json.get("dataLocation");
			ret.dataLocation =  GwtSerDerUtils.STRING.deserialize(dataLocationJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.directory.api.DirBaseValue o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.directory.api.DirBaseValue o, JSONObject ret) {

		ret.put("orgUnitUid",  GwtSerDerUtils.STRING.serialize( o.orgUnitUid ));
		ret.put("emails",  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).serialize( o.emails ));
		ret.put("hidden",  GwtSerDerUtils.BOOLEAN.serialize( o.hidden ));
		ret.put("archived",  GwtSerDerUtils.BOOLEAN.serialize( o.archived ));
		ret.put("system",  GwtSerDerUtils.BOOLEAN.serialize( o.system ));
		ret.put("dataLocation",  GwtSerDerUtils.STRING.serialize( o.dataLocation ));
	}

	public void serializeTo(net.bluemind.directory.api.DirBaseValue o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("orgUnitUid")) {
			ret.put("orgUnitUid",  GwtSerDerUtils.STRING.serialize( o.orgUnitUid ));
		}
		if (!childPropertiesToIgnore.contains("emails")) {
			ret.put("emails",  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).serialize( o.emails ));
		}
		if (!childPropertiesToIgnore.contains("hidden")) {
			ret.put("hidden",  GwtSerDerUtils.BOOLEAN.serialize( o.hidden ));
		}
		if (!childPropertiesToIgnore.contains("archived")) {
			ret.put("archived",  GwtSerDerUtils.BOOLEAN.serialize( o.archived ));
		}
		if (!childPropertiesToIgnore.contains("system")) {
			ret.put("system",  GwtSerDerUtils.BOOLEAN.serialize( o.system ));
		}
		if (!childPropertiesToIgnore.contains("dataLocation")) {
			ret.put("dataLocation",  GwtSerDerUtils.STRING.serialize( o.dataLocation ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}