/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.conditions.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleConditionGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition> {

	public MailFilterRuleConditionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition ret = new net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition ret, JSONObject json) {
		JSONValue operatorJSON = json.get("operator");
		ret.operator =  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionOperatorGwtSerDer().deserialize(operatorJSON);
		JSONValue filterJSON = json.get("filter");
		ret.filter =  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterGwtSerDer().deserialize(filterJSON);
		JSONValue conditionsJSON = json.get("conditions");
		ret.conditions =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionGwtSerDer()).deserialize(conditionsJSON);
		JSONValue clientPropertiesJSON = json.get("clientProperties");
		ret.clientProperties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(clientPropertiesJSON);
		JSONValue negateJSON = json.get("negate");
		ret.negate =  GwtSerDerUtils.BOOLEAN.deserialize(negateJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("operator")) {
			JSONValue operatorJSON = json.get("operator");
			ret.operator =  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionOperatorGwtSerDer().deserialize(operatorJSON);
		}
		if (!childPropertiesToIgnore.contains("filter")) {
			JSONValue filterJSON = json.get("filter");
			ret.filter =  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterGwtSerDer().deserialize(filterJSON);
		}
		if (!childPropertiesToIgnore.contains("conditions")) {
			JSONValue conditionsJSON = json.get("conditions");
			ret.conditions =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionGwtSerDer()).deserialize(conditionsJSON);
		}
		if (!childPropertiesToIgnore.contains("clientProperties")) {
			JSONValue clientPropertiesJSON = json.get("clientProperties");
			ret.clientProperties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(clientPropertiesJSON);
		}
		if (!childPropertiesToIgnore.contains("negate")) {
			JSONValue negateJSON = json.get("negate");
			ret.negate =  GwtSerDerUtils.BOOLEAN.deserialize(negateJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition o, JSONObject ret) {

		ret.put("operator",  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionOperatorGwtSerDer().serialize( o.operator ));
		ret.put("filter",  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterGwtSerDer().serialize( o.filter ));
		ret.put("conditions",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionGwtSerDer()).serialize( o.conditions ));
		ret.put("clientProperties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.clientProperties ));
		ret.put("negate",  GwtSerDerUtils.BOOLEAN.serialize( o.negate ));
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("operator")) {
			ret.put("operator",  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionOperatorGwtSerDer().serialize( o.operator ));
		}
		if (!childPropertiesToIgnore.contains("filter")) {
			ret.put("filter",  new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterGwtSerDer().serialize( o.filter ));
		}
		if (!childPropertiesToIgnore.contains("conditions")) {
			ret.put("conditions",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionGwtSerDer()).serialize( o.conditions ));
		}
		if (!childPropertiesToIgnore.contains("clientProperties")) {
			ret.put("clientProperties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.clientProperties ));
		}
		if (!childPropertiesToIgnore.contains("negate")) {
			ret.put("negate",  GwtSerDerUtils.BOOLEAN.serialize( o.negate ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}