/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardInfoGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCardInfo> {

	public VCardInfoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCardInfo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCardInfo ret = new net.bluemind.addressbook.api.VCardInfo();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCardInfo ret, JSONObject json) {
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.addressbook.api.gwt.serder.VCardKindGwtSerDer().deserialize(kindJSON);
		JSONValue mailJSON = json.get("mail");
		ret.mail =  GwtSerDerUtils.STRING.deserialize(mailJSON);
		JSONValue telJSON = json.get("tel");
		ret.tel =  GwtSerDerUtils.STRING.deserialize(telJSON);
		JSONValue formatedNameJSON = json.get("formatedName");
		ret.formatedName =  GwtSerDerUtils.STRING.deserialize(formatedNameJSON);
		JSONValue categoriesJSON = json.get("categories");
		ret.categories =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).deserialize(categoriesJSON);
		JSONValue memberCountJSON = json.get("memberCount");
		ret.memberCount =  GwtSerDerUtils.INT.deserialize(memberCountJSON);
		JSONValue photoJSON = json.get("photo");
		ret.photo =  GwtSerDerUtils.BOOLEAN.deserialize(photoJSON);
		JSONValue sourceJSON = json.get("source");
		ret.source =  GwtSerDerUtils.STRING.deserialize(sourceJSON);
		JSONValue hasSecurityKeyJSON = json.get("hasSecurityKey");
		ret.hasSecurityKey =  GwtSerDerUtils.BOOLEAN.deserialize(hasSecurityKeyJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCardInfo ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("kind")) {
			JSONValue kindJSON = json.get("kind");
			ret.kind =  new net.bluemind.addressbook.api.gwt.serder.VCardKindGwtSerDer().deserialize(kindJSON);
		}
		if (!childPropertiesToIgnore.contains("mail")) {
			JSONValue mailJSON = json.get("mail");
			ret.mail =  GwtSerDerUtils.STRING.deserialize(mailJSON);
		}
		if (!childPropertiesToIgnore.contains("tel")) {
			JSONValue telJSON = json.get("tel");
			ret.tel =  GwtSerDerUtils.STRING.deserialize(telJSON);
		}
		if (!childPropertiesToIgnore.contains("formatedName")) {
			JSONValue formatedNameJSON = json.get("formatedName");
			ret.formatedName =  GwtSerDerUtils.STRING.deserialize(formatedNameJSON);
		}
		if (!childPropertiesToIgnore.contains("categories")) {
			JSONValue categoriesJSON = json.get("categories");
			ret.categories =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).deserialize(categoriesJSON);
		}
		if (!childPropertiesToIgnore.contains("memberCount")) {
			JSONValue memberCountJSON = json.get("memberCount");
			ret.memberCount =  GwtSerDerUtils.INT.deserialize(memberCountJSON);
		}
		if (!childPropertiesToIgnore.contains("photo")) {
			JSONValue photoJSON = json.get("photo");
			ret.photo =  GwtSerDerUtils.BOOLEAN.deserialize(photoJSON);
		}
		if (!childPropertiesToIgnore.contains("source")) {
			JSONValue sourceJSON = json.get("source");
			ret.source =  GwtSerDerUtils.STRING.deserialize(sourceJSON);
		}
		if (!childPropertiesToIgnore.contains("hasSecurityKey")) {
			JSONValue hasSecurityKeyJSON = json.get("hasSecurityKey");
			ret.hasSecurityKey =  GwtSerDerUtils.BOOLEAN.deserialize(hasSecurityKeyJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCardInfo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCardInfo o, JSONObject ret) {

		ret.put("kind",  new net.bluemind.addressbook.api.gwt.serder.VCardKindGwtSerDer().serialize( o.kind ));
		ret.put("mail",  GwtSerDerUtils.STRING.serialize( o.mail ));
		ret.put("tel",  GwtSerDerUtils.STRING.serialize( o.tel ));
		ret.put("formatedName",  GwtSerDerUtils.STRING.serialize( o.formatedName ));
		ret.put("categories",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).serialize( o.categories ));
		ret.put("memberCount",  GwtSerDerUtils.INT.serialize( o.memberCount ));
		ret.put("photo",  GwtSerDerUtils.BOOLEAN.serialize( o.photo ));
		ret.put("source",  GwtSerDerUtils.STRING.serialize( o.source ));
		ret.put("hasSecurityKey",  GwtSerDerUtils.BOOLEAN.serialize( o.hasSecurityKey ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCardInfo o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("kind")) {
			ret.put("kind",  new net.bluemind.addressbook.api.gwt.serder.VCardKindGwtSerDer().serialize( o.kind ));
		}
		if (!childPropertiesToIgnore.contains("mail")) {
			ret.put("mail",  GwtSerDerUtils.STRING.serialize( o.mail ));
		}
		if (!childPropertiesToIgnore.contains("tel")) {
			ret.put("tel",  GwtSerDerUtils.STRING.serialize( o.tel ));
		}
		if (!childPropertiesToIgnore.contains("formatedName")) {
			ret.put("formatedName",  GwtSerDerUtils.STRING.serialize( o.formatedName ));
		}
		if (!childPropertiesToIgnore.contains("categories")) {
			ret.put("categories",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).serialize( o.categories ));
		}
		if (!childPropertiesToIgnore.contains("memberCount")) {
			ret.put("memberCount",  GwtSerDerUtils.INT.serialize( o.memberCount ));
		}
		if (!childPropertiesToIgnore.contains("photo")) {
			ret.put("photo",  GwtSerDerUtils.BOOLEAN.serialize( o.photo ));
		}
		if (!childPropertiesToIgnore.contains("source")) {
			ret.put("source",  GwtSerDerUtils.STRING.serialize( o.source ));
		}
		if (!childPropertiesToIgnore.contains("hasSecurityKey")) {
			ret.put("hasSecurityKey",  GwtSerDerUtils.BOOLEAN.serialize( o.hasSecurityKey ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}