import { computed, ref } from "vue";

import { MessageBody } from "@bluemind/backend.mail.api";
import store from "@bluemind/store";

import { getFhHeader } from "../../helpers";
import { GET_CONFIGURATION } from "../../store/types/actions";

type File = {
    size: number;
    headers: MessageBody.Header[];
};

export default function useFileDetails(props: { data: { file: File } }) {
    const file = computed(() => props.data.file);

    const maxFilesize = ref(null);
    const initializeConfig = async () => {
        const config = await store.dispatch(`mail/${GET_CONFIGURATION}`);
        maxFilesize.value = config.maxFilesize;
    };
    initializeConfig();

    const isTooLarge = computed(
        () => maxFilesize.value === null || !(maxFilesize.value > file.value.size || maxFilesize.value === 0)
    );
    const fhHeader = computed(() => getFhHeader(file.value.headers));
    const isDetached = computed(() => !!fhHeader.value);
    const isReadOnly = computed(() => {
        const CURRENT_CONVERSATION = store.getters["mail/CURRENT_CONVERSATION_METADATA"];
        return CURRENT_CONVERSATION && !store.state.mail.folders[CURRENT_CONVERSATION.folderRef.key]?.writable;
    });

    return { isTooLarge, isDetached, isReadOnly };
}
