/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.filehosting.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class FileHostingPublicLinkGwtSerDer implements GwtSerDer<net.bluemind.filehosting.api.FileHostingPublicLink> {

	public FileHostingPublicLinkGwtSerDer( ) {
	}

	@Override
	public net.bluemind.filehosting.api.FileHostingPublicLink deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.filehosting.api.FileHostingPublicLink ret = new net.bluemind.filehosting.api.FileHostingPublicLink();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.filehosting.api.FileHostingPublicLink ret, JSONObject json) {
		JSONValue urlJSON = json.get("url");
		ret.url =  GwtSerDerUtils.STRING.deserialize(urlJSON);
		JSONValue expirationDateJSON = json.get("expirationDate");
		ret.expirationDate =  GwtSerDerUtils.LONG.deserialize(expirationDateJSON);
	}

	public void deserializeTo(net.bluemind.filehosting.api.FileHostingPublicLink ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("url")) {
			JSONValue urlJSON = json.get("url");
			ret.url =  GwtSerDerUtils.STRING.deserialize(urlJSON);
		}
		if (!childPropertiesToIgnore.contains("expirationDate")) {
			JSONValue expirationDateJSON = json.get("expirationDate");
			ret.expirationDate =  GwtSerDerUtils.LONG.deserialize(expirationDateJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.filehosting.api.FileHostingPublicLink o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.filehosting.api.FileHostingPublicLink o, JSONObject ret) {

		ret.put("url",  GwtSerDerUtils.STRING.serialize( o.url ));
		ret.put("expirationDate",  GwtSerDerUtils.LONG.serialize( o.expirationDate ));
	}

	public void serializeTo(net.bluemind.filehosting.api.FileHostingPublicLink o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("url")) {
			ret.put("url",  GwtSerDerUtils.STRING.serialize( o.url ));
		}
		if (!childPropertiesToIgnore.contains("expirationDate")) {
			ret.put("expirationDate",  GwtSerDerUtils.LONG.serialize( o.expirationDate ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}