/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.contact.handlers;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.bluemind.addressbook.api.IVCardServicePromise;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.rest.http.VertxPromiseServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCardStream
implements ReadStream<Buffer> {
    private static Logger logger = LoggerFactory.getLogger(VCardStream.class);
    private Handler<Buffer> dataHandler;
    private boolean closed;
    private boolean paused;
    private Handler<Void> endHandler;
    private boolean readInProgress = false;
    private Map<String, List<String>> cards;
    private Iterator<String> serviceIterator;
    private Iterator<String> currentCardIterator;
    private IServiceProvider clientProvider;
    private IVCardServicePromise currentService;
    private Handler<Throwable> exceptionHandler;

    public VCardStream(IServiceProvider iServiceProvider, Map<String, List<String>> map) {
        this.serviceIterator = map.keySet().iterator();
        this.cards = map;
        this.clientProvider = iServiceProvider;
    }

    public VCardStream handler(Handler<Buffer> handler) {
        this.check();
        this.dataHandler = handler;
        if (this.dataHandler != null && !this.paused && !this.closed) {
            this.doRead();
        }
        return this;
    }

    public VCardStream pause() {
        this.check();
        this.readInProgress = false;
        this.paused = true;
        return this;
    }

    public VCardStream resume() {
        this.check();
        if (this.paused && !this.closed) {
            this.paused = false;
            if (this.dataHandler != null) {
                this.doRead();
            }
        }
        return this;
    }

    public VCardStream exceptionHandler(Handler<Throwable> handler) {
        this.check();
        this.exceptionHandler = handler;
        return this;
    }

    public VCardStream endHandler(Handler<Void> handler) {
        this.check();
        this.endHandler = handler;
        return this;
    }

    private void check() {
    }

    private void doRead() {
        if (!this.readInProgress) {
            Object object;
            this.readInProgress = true;
            if (this.currentCardIterator == null || !this.currentCardIterator.hasNext()) {
                object = this.serviceIterator.next();
                this.currentService = (IVCardServicePromise)((VertxPromiseServiceProvider)this.clientProvider).instance(IVCardServicePromise.class, new String[]{object});
                this.currentCardIterator = this.cards.get(object).iterator();
            }
            object = new ArrayList(10);
            int n = 0;
            while (this.currentCardIterator.hasNext() && n < 10) {
                object.add(this.currentCardIterator.next());
                ++n;
            }
            CompletableFuture completableFuture = this.currentService.exportCards((List)object);
            completableFuture.thenAccept(string -> {
                this.readInProgress = false;
                this.dataHandler.handle((Object)Buffer.buffer((String)string));
                if (!this.currentCardIterator.hasNext() && !this.serviceIterator.hasNext()) {
                    this.handleEnd();
                } else if (!this.paused && this.dataHandler != null) {
                    this.doRead();
                }
            });
            completableFuture.exceptionally(throwable -> {
                this.handleException((Throwable)throwable);
                this.readInProgress = false;
                return null;
            });
        }
    }

    private void handleEnd() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    private void handleException(Throwable throwable) {
        if (this.exceptionHandler != null && throwable instanceof Exception) {
            this.exceptionHandler.handle((Object)throwable);
        } else {
            logger.error("Unhandled exception", throwable);
        }
    }

    public ReadStream<Buffer> fetch(long l) {
        return this;
    }
}

