/**
 * BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * @fileoverview Messages common to Editor UI components.
 * This is used to support i18n via pootle.
 *
 */

goog.provide('bluemind.ui.editor.messages');


/**
 * @desc Link
 * @meaning editor.messages.link
 */
bluemind.ui.editor.messages.MSG_LINK_CAPTION = goog.getMsg('Link');
/**
 * @desc Edit Link
 * @meaning editor.messages.link.edit
 */
bluemind.ui.editor.messages.MSG_EDIT_LINK = goog.getMsg('Edit Link');
/**
 * @desc Text to display:
 * @meaning editor.messages.textToDisplay
 */
bluemind.ui.editor.messages.MSG_TEXT_TO_DISPLAY = goog.getMsg('Text to display:');
/**
 * @desc Link to:
 * @meaning editor.messages.link.to
 */
bluemind.ui.editor.messages.MSG_LINK_TO = goog.getMsg('Link to:');
/**
 * @desc Web address
 * @meaning editor.messages.webAddress
 */
bluemind.ui.editor.messages.MSG_ON_THE_WEB = goog.getMsg('Web address');
/**
 * @desc Link to a page or file somewhere else on the web
 * @meaning editor.messages.link.external
 */
bluemind.ui.editor.messages.MSG_ON_THE_WEB_TIP = goog.getMsg('Link to a page or file somewhere else on the web');
/**
 * @desc Test this link
 * @meaning editor.messages.link.test
 */
bluemind.ui.editor.messages.MSG_TEST_THIS_LINK = goog.getMsg('Test this link');
/**
 * @desc To what URL should this link go?
 * @meaning editor.messages.link.shouldGo.url
 */
bluemind.ui.editor.messages.MSG_WHAT_URL = goog.getMsg('To what URL should this link go?');
/**
 * @desc Email address
 * @meaning editor.messages.link.email
 */
bluemind.ui.editor.messages.MSG_EMAIL_ADDRESS = goog.getMsg('Email address');
/**
 * @desc Link to an email address
 * @meaning editor.messages.link.email.info
 */
bluemind.ui.editor.messages.MSG_EMAIL_ADDRESS_TIP = goog.getMsg('Link to an email address');
/**
 * @desc Invalid email address
 * @meaning editor.messages.invalidEmail
 */
bluemind.ui.editor.messages.MSG_INVALID_EMAIL = goog.getMsg('Invalid email address');
/**
 * @desc To what email address should this link?
 * @meaning editor.messages.link.shouldGo.email
 */
bluemind.ui.editor.messages.MSG_WHAT_EMAIL = goog.getMsg('To what email address should this link?');
/**
 * @desc Small font size
 * @meaning editor.messages.fontSize.small
 */
bluemind.ui.editor.messages.MSG_FONT_SIZE_SMALL = goog.getMsg('Small');
/**
 * @desc Normal font size
 * @meaning editor.messages.fontSize.normal
 */
bluemind.ui.editor.messages.MSG_FONT_SIZE_NORMAL = goog.getMsg('Normal');
/**
 * @desc Large font size
 * @meaning editor.messages.fontSize.large
 */
bluemind.ui.editor.messages.MSG_FONT_SIZE_LARGE = goog.getMsg('Large');
/**
 * @desc Huge font size
 * @meaning editor.messages.fontSize.huge
 */
bluemind.ui.editor.messages.MSG_FONT_SIZE_HUGE = goog.getMsg('Huge');
/**
 * @desc Normal font family
 * @meaning editor.messages.fontFamily.normal
 */
bluemind.ui.editor.messages.MSG_FONT_NORMAL = goog.getMsg('Normal');
/**
 * @desc Normal / serif font family
 * @meaning editor.messages.fontFamily.serif
 */
bluemind.ui.editor.messages.MSG_FONT_NORMAL_SERIF = goog.getMsg('Normal / serif');
/**
 * @desc Heading
 * @meaning editor.messages.format.heading
 */
bluemind.ui.editor.messages.MSG_FORMAT_HEADING = goog.getMsg('Heading');
/**
 * @desc Subheading
 * @meaning editor.messages.format.subheading
 */
bluemind.ui.editor.messages.MSG_FORMAT_SUBHEADING = goog.getMsg('Subheading');
/**
 * @desc Minor heading
 * @meaning editor.messages.format.minorHeading
 */
bluemind.ui.editor.messages.MSG_FORMAT_MINOR_HEADING = goog.getMsg('Minor heading');
/**
 * @desc Normal text format
 * @meaning editor.messages.format.normal
 */
bluemind.ui.editor.messages.MSG_FORMAT_NORMAL = goog.getMsg('Normal');
/**
 * @desc Format
 * @meaning editor.messages.format.block.title
 */
bluemind.ui.editor.messages.MSG_FORMAT_BLOCK_TITLE = goog.getMsg('Format');
/**
 * @desc Format
 * @meaning editor.messages.format.block.info
 */
bluemind.ui.editor.messages.MSG_FORMAT_BLOCK_CAPTION = goog.getMsg('Format');
/**
 * @desc Undo
 * @meaning editor.messages.undo
 */
bluemind.ui.editor.messages.MSG_UNDO_TITLE = goog.getMsg('Undo');
/**
 * @desc Redo
 * @meaning editor.messages.redo
 */
bluemind.ui.editor.messages.MSG_REDO_TITLE = goog.getMsg('Redo');
/**
 * @desc Font
 * @meaning editor.messages.font
 */
bluemind.ui.editor.messages.MSG_FONT_FACE_TITLE = goog.getMsg('Font');
/**
 * @desc Font size
 * @meaning editor.messages.fontSize
 */
bluemind.ui.editor.messages.MSG_FONT_SIZE_TITLE = goog.getMsg('Font size');
/**
 * @desc Text color
 * @meaning editor.messages.textColor
 */
bluemind.ui.editor.messages.MSG_FONT_COLOR_TITLE = goog.getMsg('Text color');
/**
 * @desc Bold
 * @meaning editor.messages.bold
 */
bluemind.ui.editor.messages.MSG_BOLD_TITLE = goog.getMsg('Bold');
/**
 * @desc Italic
 * @meaning editor.messages.italic
 */
bluemind.ui.editor.messages.MSG_ITALIC_TITLE = goog.getMsg('Italic');
/**
 * @desc Underline
 * @meaning editor.messages.underline
 */
bluemind.ui.editor.messages.MSG_UNDERLINE_TITLE = goog.getMsg('Underline');
/**
 * @desc Text background color
 * @meaning editor.messages.backgroundColor
 */
bluemind.ui.editor.messages.MSG_BACKGROUND_COLOR_TITLE = goog.getMsg('Text background color');
/**
 * @desc Add or remove link
 * @meaning editor.messages.link.addRemove
 */
bluemind.ui.editor.messages.MSG_LINK_TITLE = goog.getMsg('Add or remove link');
/**
 * @desc Numbered list
 * @meaning editor.messages.list.ordered
 */
bluemind.ui.editor.messages.MSG_ORDERED_LIST_TITLE = goog.getMsg('Numbered list');
/**
 * @desc Bullet list
 * @meaning editor.messages.list.unordered
 */
bluemind.ui.editor.messages.MSG_UNORDERED_LIST_TITLE = goog.getMsg('Bullet list');
/**
 * @desc Decrease indent
 * @meaning editor.messages.indent.decrease
 */
bluemind.ui.editor.messages.MSG_OUTDENT_TITLE = goog.getMsg('Decrease indent');
/**
 * @desc Increase indent
 * @meaning editor.messages.indent.increase
 */
bluemind.ui.editor.messages.MSG_INDENT_TITLE = goog.getMsg('Increase indent');
/**
 * @desc Align left
 * @meaning editor.messages.align.left
 */
bluemind.ui.editor.messages.MSG_ALIGN_LEFT_TITLE = goog.getMsg('Align left');
/**
 * @desc Align center
 * @meaning editor.messages.align.center
 */
bluemind.ui.editor.messages.MSG_ALIGN_CENTER_TITLE = goog.getMsg('Align center');
/**
 * @desc Align right
 * @meaning editor.messages.align.right
 */
bluemind.ui.editor.messages.MSG_ALIGN_RIGHT_TITLE = goog.getMsg('Align right');
/**
 * @desc Justify
 * @meaning editor.messages.align.justify
 */
bluemind.ui.editor.messages.MSG_JUSTIFY_TITLE = goog.getMsg('Justify');
/**
 * @desc Remove formatting
 * @meaning editor.messages.format.remove
 */
bluemind.ui.editor.messages.MSG_REMOVE_FORMAT_TITLE = goog.getMsg('Remove formatting');
/**
 * @desc Insert image
 * @meaning editor.messages.image.insert
 */
bluemind.ui.editor.messages.MSG_IMAGE_TITLE = goog.getMsg('Insert image');
/**
 * @desc Strikethrough
 * @meaning editor.messages.strikestrought
 */
bluemind.ui.editor.messages.MSG_STRIKE_THROUGH_TITLE = goog.getMsg('Strikethrough');
/**
 * @desc Left-to-right
 * @meaning editor.messages.direction.leftToRight
 */
bluemind.ui.editor.messages.MSG_DIR_LTR_TITLE = goog.getMsg('Left-to-right');
/**
 * @desc Right-to-left
 * @meaning editor.messages.diurection.rightToLeft
 */
bluemind.ui.editor.messages.MSG_DIR_RTL_TITLE = goog.getMsg('Right-to-left');
/**
 * @desc Quote
 * @meaning editor.messages.quote
 */
bluemind.ui.editor.messages.MSG_BLOCKQUOTE_TITLE = goog.getMsg('Quote');
/**
 * @desc Edit HTML source
 * @meaning editor.messages.html
 */
bluemind.ui.editor.messages.MSG_EDIT_HTML_TITLE = goog.getMsg('Edit HTML source');
/**
 * @desc Subscript
 * @meaning editor.messages.subscript
 */
bluemind.ui.editor.messages.MSG_SUBSCRIPT = goog.getMsg('Subscript');
/**
 * @desc Superscript
 * @meaning editor.messages.superscript
 */
bluemind.ui.editor.messages.MSG_SUPERSCRIPT = goog.getMsg('Superscript');
/**
 * @desc Edit HTML
 * @meaning editor.messages.html.info
 */
bluemind.ui.editor.messages.MSG_EDIT_HTML_CAPTION = goog.getMsg('HTML');
/**
 * @desc Go to link:
 * @meaning editor.messages.link.goTo
 */
bluemind.ui.editor.messages.MSG_LINK_BUBBLE_TEST_LINK = goog.getMsg('Go to link:');
/**
 * @desc Change
 * @meaning editor.messages.bubble.change
 */
bluemind.ui.editor.messages.MSG_BUBBLE_CHANGE = goog.getMsg('Change');
/**
 * @desc Remove
 * @meaning editor.messages.bubble.remove
 */
bluemind.ui.editor.messages.MSG_BUBBLE_REMOVE = goog.getMsg('Remove');
/**
 * @desc Image
 * @meaning editor.messages.bubble.image
 */
bluemind.ui.editor.messages.MSG_BUBBLE_IMAGE = goog.getMsg('Image');
/**
 * @desc Invalid URL
 * @meaning editor.messages.bubble.invalidUrl
 */
bluemind.ui.editor.messages.MSG_INVALID_URL_LINK_BUBBLE = goog.getMsg('Invalid URL');
/**
 * @desc This link cannot be tested.
 * @meaning editor.messages.link.unsafe
 */
bluemind.ui.editor.messages.MSG_UNSAFE_LINK = goog.getMsg('This link cannot be tested.');
/**
 * @desc Cancel
 * @meaning editor.messages.cancel
 */
bluemind.ui.editor.messages.MSG_CANCEL = goog.getMsg('Cancel');
/**
 * @desc Ok
 * @meaning editor.messages.ok
 */
bluemind.ui.editor.messages.MSG_OK = goog.getMsg('Ok');
/**
 * @desc Edit Image
 * @meaning editor.messages.image.edit
 */
bluemind.ui.editor.messages.MSG_IMAGE_EDIT = goog.getMsg('Edit Image');
/**
 * @desc Image source:
 * @meaning editor.messages.image.source
 */
bluemind.ui.editor.messages.MSG_IMAGE_SOURCE = goog.getMsg('Image source:');
/**
 * @desc From an URL
 * @meaning editor.messages.image.url
 */
bluemind.ui.editor.messages.MSG_IMAGE_FROM_URL = goog.getMsg('From an URL');
/**
 * @desc Link an image from a web server.
 * @meaning editor.messages.image.external
 */
bluemind.ui.editor.messages.MSG_IMAGE_FROM_WEB = goog.getMsg('Link an image from a web server.');
/**
 * @desc Image from my computer
 * @meaning editor.messages.image.local
 */
bluemind.ui.editor.messages.MSG_IMAGE_FROM_COMPUTER = goog.getMsg('Image from my computer.');
/**
 * @desc Upload an image from the local disk. Fit for image smaller than 10 KB.
 * @meaning editor.messages.image.upload
 */
bluemind.ui.editor.messages.MSG_IMAGE_UPLOAD = goog.getMsg('Upload an image from the local disk. Fit for image smaller than 10 KB.');
