/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api;

import java.util.ArrayList;
import java.util.HashMap;

import net.bluemind.addressbook.api.VCard;
import net.bluemind.core.api.BMApi;

/**
 * SharedMailbox represents a specific user, with a login and a list of emails.
 * Informations like firstname, lastname and phones are store in a
 * {@link VCard}.
 *
 * Users are part of a domain (and only one).
 *
 * They are stored as items in a container users_[domainUid].
 * 
 * They are user without login capabilities
 */
@BMApi(version = "3")
public class SharedMailbox extends User {

	public SharedMailbox() {
		this.password = null;
		this.passwordLastChange = null;
		this.passwordMustChange = false;
		this.passwordNeverExpires = false;
		this.loginCaps = false;
	}

	@Override
	public String toString() {
		return "SharedMailbox [login=" + login + ", archived=" + archived + ", system=" + system + ", hidden=" + hidden
				+ ", loginCaps=" + loginCaps + ", routing=" + routing + ", dataLocation=" + dataLocation + "]";
	}

	public SharedMailbox copy() {
		SharedMailbox u = new SharedMailbox();
		u.accountType = accountType;
		u.archived = archived;
		u.contactInfos = contactInfos != null ? contactInfos.copy() : null;
		u.dataLocation = dataLocation;
		u.emails = new ArrayList<>(emails);
		u.hidden = hidden;
		u.login = login;
		u.mailboxCopyGuid = mailboxCopyGuid;
		u.orgUnitUid = orgUnitUid;
		u.password = password;
		u.passwordLastChange = passwordLastChange;
		u.passwordMustChange = passwordMustChange;
		u.passwordNeverExpires = passwordNeverExpires;
		u.properties = new HashMap<>(properties);
		u.quota = quota;
		u.loginCaps = loginCaps;
		u.routing = routing;
		u.system = system;
		return u;
	}

	public static SharedMailbox create(User user) {
		SharedMailbox u = new SharedMailbox();
		u.accountType = user.accountType;
		u.archived = user.archived;
		u.contactInfos = user.contactInfos != null ? user.contactInfos.copy() : null;
		u.dataLocation = user.dataLocation;
		u.emails = new ArrayList<>(user.emails);
		u.hidden = user.hidden;
		u.login = user.login;
		u.mailboxCopyGuid = user.mailboxCopyGuid;
		u.orgUnitUid = user.orgUnitUid;
		u.properties = new HashMap<>(user.properties);
		u.quota = user.quota;
		u.routing = user.routing;
		u.system = user.system;
		return u;
	}
}
