/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.hot.upgrade.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class HotUpgradeTaskFilterGwtSerDer implements GwtSerDer<net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter> {

	public HotUpgradeTaskFilterGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter ret = new net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter ret, JSONObject json) {
		JSONValue operationJSON = json.get("operation");
		ret.operation =  GwtSerDerUtils.STRING.deserialize(operationJSON);
		JSONValue statusesJSON = json.get("statuses");
		ret.statuses =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer()).deserialize(statusesJSON);
		JSONValue onlyRetryableJSON = json.get("onlyRetryable");
		ret.onlyRetryable =  GwtSerDerUtils.BOOLEAN.deserialize(onlyRetryableJSON);
		JSONValue onlyReadyJSON = json.get("onlyReady");
		ret.onlyReady =  GwtSerDerUtils.BOOLEAN.deserialize(onlyReadyJSON);
		JSONValue onlyMandatoryJSON = json.get("onlyMandatory");
		ret.onlyMandatory =  GwtSerDerUtils.BOOLEAN.deserialize(onlyMandatoryJSON);
		JSONValue modeJSON = json.get("mode");
		ret.mode =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskExecutionModeGwtSerDer()).deserialize(modeJSON);
	}

	public void deserializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("operation")) {
			JSONValue operationJSON = json.get("operation");
			ret.operation =  GwtSerDerUtils.STRING.deserialize(operationJSON);
		}
		if (!childPropertiesToIgnore.contains("statuses")) {
			JSONValue statusesJSON = json.get("statuses");
			ret.statuses =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer()).deserialize(statusesJSON);
		}
		if (!childPropertiesToIgnore.contains("onlyRetryable")) {
			JSONValue onlyRetryableJSON = json.get("onlyRetryable");
			ret.onlyRetryable =  GwtSerDerUtils.BOOLEAN.deserialize(onlyRetryableJSON);
		}
		if (!childPropertiesToIgnore.contains("onlyReady")) {
			JSONValue onlyReadyJSON = json.get("onlyReady");
			ret.onlyReady =  GwtSerDerUtils.BOOLEAN.deserialize(onlyReadyJSON);
		}
		if (!childPropertiesToIgnore.contains("onlyMandatory")) {
			JSONValue onlyMandatoryJSON = json.get("onlyMandatory");
			ret.onlyMandatory =  GwtSerDerUtils.BOOLEAN.deserialize(onlyMandatoryJSON);
		}
		if (!childPropertiesToIgnore.contains("mode")) {
			JSONValue modeJSON = json.get("mode");
			ret.mode =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskExecutionModeGwtSerDer()).deserialize(modeJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter o, JSONObject ret) {

		ret.put("operation",  GwtSerDerUtils.STRING.serialize( o.operation ));
		ret.put("statuses",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer()).serialize( o.statuses ));
		ret.put("onlyRetryable",  GwtSerDerUtils.BOOLEAN.serialize( o.onlyRetryable ));
		ret.put("onlyReady",  GwtSerDerUtils.BOOLEAN.serialize( o.onlyReady ));
		ret.put("onlyMandatory",  GwtSerDerUtils.BOOLEAN.serialize( o.onlyMandatory ));
		ret.put("mode",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskExecutionModeGwtSerDer()).serialize( o.mode ));
	}

	public void serializeTo(net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("operation")) {
			ret.put("operation",  GwtSerDerUtils.STRING.serialize( o.operation ));
		}
		if (!childPropertiesToIgnore.contains("statuses")) {
			ret.put("statuses",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskStatusGwtSerDer()).serialize( o.statuses ));
		}
		if (!childPropertiesToIgnore.contains("onlyRetryable")) {
			ret.put("onlyRetryable",  GwtSerDerUtils.BOOLEAN.serialize( o.onlyRetryable ));
		}
		if (!childPropertiesToIgnore.contains("onlyReady")) {
			ret.put("onlyReady",  GwtSerDerUtils.BOOLEAN.serialize( o.onlyReady ));
		}
		if (!childPropertiesToIgnore.contains("onlyMandatory")) {
			ret.put("onlyMandatory",  GwtSerDerUtils.BOOLEAN.serialize( o.onlyMandatory ));
		}
		if (!childPropertiesToIgnore.contains("mode")) {
			ret.put("mode",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.hot.upgrade.gwt.serder.HotUpgradeTaskExecutionModeGwtSerDer()).serialize( o.mode ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}