/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class TotpCredentialGwtSerDer implements GwtSerDer<net.bluemind.system.api.TotpCredential> {

	public TotpCredentialGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.TotpCredential deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.TotpCredential ret = new net.bluemind.system.api.TotpCredential();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.TotpCredential ret, JSONObject json) {
		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		JSONValue secretJSON = json.get("secret");
		ret.secret =  GwtSerDerUtils.STRING.deserialize(secretJSON);
		JSONValue tokenJSON = json.get("token");
		ret.token =  GwtSerDerUtils.STRING.deserialize(tokenJSON);
	}

	public void deserializeTo(net.bluemind.system.api.TotpCredential ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("displayName")) {
			JSONValue displayNameJSON = json.get("displayName");
			ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		}
		if (!childPropertiesToIgnore.contains("secret")) {
			JSONValue secretJSON = json.get("secret");
			ret.secret =  GwtSerDerUtils.STRING.deserialize(secretJSON);
		}
		if (!childPropertiesToIgnore.contains("token")) {
			JSONValue tokenJSON = json.get("token");
			ret.token =  GwtSerDerUtils.STRING.deserialize(tokenJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.system.api.TotpCredential o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.TotpCredential o, JSONObject ret) {

		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		ret.put("secret",  GwtSerDerUtils.STRING.serialize( o.secret ));
		ret.put("token",  GwtSerDerUtils.STRING.serialize( o.token ));
	}

	public void serializeTo(net.bluemind.system.api.TotpCredential o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("displayName")) {
			ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		}
		if (!childPropertiesToIgnore.contains("secret")) {
			ret.put("secret",  GwtSerDerUtils.STRING.serialize( o.secret ));
		}
		if (!childPropertiesToIgnore.contains("token")) {
			ret.put("token",  GwtSerDerUtils.STRING.serialize( o.token ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}